/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.buffer;

import io.netty.buffer.AdaptiveByteBufAllocator;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.microbench.util.AbstractMicrobenchmark;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;

@State(value=Scope.Benchmark)
public class ByteBufAllocatorBenchmark
extends AbstractMicrobenchmark {
    private static final ByteBufAllocator unpooledAllocator = new UnpooledByteBufAllocator(true);
    private static final ByteBufAllocator pooledAllocator = new PooledByteBufAllocator(true, 4, 4, 8192, 11, 0, 0, 0, true, 0);
    private static final ByteBufAllocator adaptiveAllocator = new AdaptiveByteBufAllocator();
    private static final int MAX_LIVE_BUFFERS = 8192;
    private static final Random rand = new Random();
    private static final ByteBuf[] unpooledHeapBuffers = new ByteBuf[8192];
    private static final ByteBuf[] unpooledDirectBuffers = new ByteBuf[8192];
    private static final ByteBuf[] pooledHeapBuffers = new ByteBuf[8192];
    private static final ByteBuf[] pooledDirectBuffers = new ByteBuf[8192];
    private static final ByteBuf[] defaultPooledHeapBuffers = new ByteBuf[8192];
    private static final ByteBuf[] defaultPooledDirectBuffers = new ByteBuf[8192];
    private static final ByteBuf[] adaptiveHeapBuffers = new ByteBuf[8192];
    private static final ByteBuf[] adaptiveDirectBuffers = new ByteBuf[8192];
    @Param(value={"00000", "00256", "01024", "04096", "16384", "65536"})
    public int size;

    @TearDown
    public void releaseBuffers() {
        List bufferLists = Arrays.asList(unpooledHeapBuffers, unpooledDirectBuffers, pooledHeapBuffers, pooledDirectBuffers, defaultPooledHeapBuffers, defaultPooledDirectBuffers, adaptiveHeapBuffers, adaptiveDirectBuffers);
        Iterator iterator = bufferLists.iterator();
        while (iterator.hasNext()) {
            Object[] bufs;
            for (ByteBuf byteBuf : bufs = (ByteBuf[])iterator.next()) {
                if (byteBuf == null || byteBuf.refCnt() <= 0) continue;
                byteBuf.release();
            }
            Arrays.fill(bufs, null);
        }
    }

    @Benchmark
    public void unpooledHeapAllocAndFree() {
        int idx = rand.nextInt(unpooledHeapBuffers.length);
        ByteBuf oldBuf = unpooledHeapBuffers[idx];
        if (oldBuf != null) {
            oldBuf.release();
        }
        ByteBufAllocatorBenchmark.unpooledHeapBuffers[idx] = unpooledAllocator.heapBuffer(this.size);
    }

    @Benchmark
    public void unpooledDirectAllocAndFree() {
        int idx = rand.nextInt(unpooledDirectBuffers.length);
        ByteBuf oldBuf = unpooledDirectBuffers[idx];
        if (oldBuf != null) {
            oldBuf.release();
        }
        ByteBufAllocatorBenchmark.unpooledDirectBuffers[idx] = unpooledAllocator.directBuffer(this.size);
    }

    @Benchmark
    public void pooledHeapAllocAndFree() {
        int idx = rand.nextInt(pooledHeapBuffers.length);
        ByteBuf oldBuf = pooledHeapBuffers[idx];
        if (oldBuf != null) {
            oldBuf.release();
        }
        ByteBufAllocatorBenchmark.pooledHeapBuffers[idx] = pooledAllocator.heapBuffer(this.size);
    }

    @Benchmark
    public void pooledDirectAllocAndFree() {
        int idx = rand.nextInt(pooledDirectBuffers.length);
        ByteBuf oldBuf = pooledDirectBuffers[idx];
        if (oldBuf != null) {
            oldBuf.release();
        }
        ByteBufAllocatorBenchmark.pooledDirectBuffers[idx] = pooledAllocator.directBuffer(this.size);
    }

    @Benchmark
    public void defaultPooledHeapAllocAndFree() {
        int idx = rand.nextInt(defaultPooledHeapBuffers.length);
        ByteBuf oldBuf = defaultPooledHeapBuffers[idx];
        if (oldBuf != null) {
            oldBuf.release();
        }
        ByteBufAllocatorBenchmark.defaultPooledHeapBuffers[idx] = PooledByteBufAllocator.DEFAULT.heapBuffer(this.size);
    }

    @Benchmark
    public void defaultPooledDirectAllocAndFree() {
        int idx = rand.nextInt(defaultPooledDirectBuffers.length);
        ByteBuf oldBuf = defaultPooledDirectBuffers[idx];
        if (oldBuf != null) {
            oldBuf.release();
        }
        ByteBufAllocatorBenchmark.defaultPooledDirectBuffers[idx] = PooledByteBufAllocator.DEFAULT.directBuffer(this.size);
    }

    @Benchmark
    public void adaptiveHeapAllocAndFree() {
        int idx = rand.nextInt(adaptiveHeapBuffers.length);
        ByteBuf oldBuf = adaptiveHeapBuffers[idx];
        if (oldBuf != null) {
            oldBuf.release();
        }
        ByteBufAllocatorBenchmark.adaptiveHeapBuffers[idx] = adaptiveAllocator.heapBuffer(this.size);
    }

    @Benchmark
    public void adaptiveDirectAllocAndFree() {
        int idx = rand.nextInt(adaptiveDirectBuffers.length);
        ByteBuf oldBuf = adaptiveDirectBuffers[idx];
        if (oldBuf != null) {
            oldBuf.release();
        }
        ByteBufAllocatorBenchmark.adaptiveDirectBuffers[idx] = adaptiveAllocator.directBuffer(this.size);
    }
}

