/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.util.AsciiString;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public final class HpackHeader {
    private static final String ALPHABET = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_";
    final CharSequence name;
    final CharSequence value;

    private HpackHeader(byte[] name, byte[] value) {
        this.name = new AsciiString(name, false);
        this.value = new AsciiString(value, false);
    }

    static List<HpackHeader> createHeaders(int numHeaders, int nameLength, int valueLength, boolean limitToAscii) {
        ArrayList<HpackHeader> hpackHeaders = new ArrayList<HpackHeader>(numHeaders);
        for (int i = 0; i < numHeaders; ++i) {
            byte[] name = HpackHeader.randomBytes(new byte[nameLength], true);
            byte[] value = HpackHeader.randomBytes(new byte[valueLength], limitToAscii);
            hpackHeaders.add(new HpackHeader(name, value));
        }
        return hpackHeaders;
    }

    private static byte[] randomBytes(byte[] bytes, boolean limitToAscii) {
        Random r = new Random();
        if (limitToAscii) {
            for (int index = 0; index < bytes.length; ++index) {
                int charIndex = r.nextInt(ALPHABET.length());
                bytes[index] = (byte)ALPHABET.charAt(charIndex);
            }
        } else {
            r.nextBytes(bytes);
        }
        return bytes;
    }
}

