/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.microbench.util.AbstractMicrobenchmark;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.TearDown;

public class ByteBufCopy2Benchmark
extends AbstractMicrobenchmark {
    @Param(value={"7", "36", "128", "512"})
    private int size;
    @Param(value={"true", "false"})
    private boolean directByteBuf;
    private ByteBuf buffer1;
    private ByteBuf buffer2;

    @Setup
    public void setup() {
        this.buffer1 = this.directByteBuf ? ByteBufAllocator.DEFAULT.directBuffer(this.size, this.size) : ByteBufAllocator.DEFAULT.heapBuffer(this.size, this.size);
        this.buffer2 = this.directByteBuf ? ByteBufAllocator.DEFAULT.directBuffer(this.size, this.size) : ByteBufAllocator.DEFAULT.heapBuffer(this.size, this.size);
        for (int i = 0; i < this.size; ++i) {
            this.buffer2.setByte(i, 165);
        }
    }

    @Benchmark
    public ByteBuf setBytes() {
        return this.buffer1.setBytes(0, this.buffer2, 0, this.size);
    }

    @TearDown
    public void tearDown() {
        this.buffer1.release();
        this.buffer2.release();
    }

    static {
        System.setProperty("io.netty.buffer.bytebuf.checkAccessible", "false");
    }
}

