/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectEncoder;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestEncoder;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Benchmark)
@Warmup(iterations=10)
@Measurement(iterations=20)
public class HttpRequestEncoderInsertBenchmark
extends AbstractMicrobenchmark {
    private static final String[] PARAMS = new String[]{"eventType=CRITICAL", "from=0", "to=1497437160327", "limit=10", "offset=0"};
    @Param(value={"1024", "128000"})
    private int samples;
    private String[] uris;
    private int index;
    private final OldHttpRequestEncoder encoderOld = new OldHttpRequestEncoder();
    private final HttpRequestEncoder encoderNew = new HttpRequestEncoder();

    @Setup
    public void setup() {
        ArrayList<String[]> permutations = new ArrayList<String[]>();
        HttpRequestEncoderInsertBenchmark.permute((String[])PARAMS.clone(), 0, permutations);
        String[] allCombinations = new String[permutations.size()];
        String base = "http://localhost?";
        for (int i = 0; i < permutations.size(); ++i) {
            StringBuilder sb = new StringBuilder(base);
            String[] p = (String[])permutations.get(i);
            for (int j = 0; j < p.length; ++j) {
                if (j != 0) {
                    sb.append('&');
                }
                sb.append(p[j]);
            }
            allCombinations[i] = sb.toString();
        }
        this.uris = new String[this.samples];
        Random rand = new Random(42L);
        for (int i = 0; i < this.uris.length; ++i) {
            this.uris[i] = allCombinations[rand.nextInt(allCombinations.length)];
        }
        this.index = 0;
    }

    private static void permute(String[] arr, int start, List<String[]> out) {
        if (start == arr.length - 1) {
            out.add(Arrays.copyOf(arr, arr.length));
            return;
        }
        for (int i = start; i < arr.length; ++i) {
            HttpRequestEncoderInsertBenchmark.swap(arr, start, i);
            HttpRequestEncoderInsertBenchmark.permute(arr, start + 1, out);
            HttpRequestEncoderInsertBenchmark.swap(arr, start, i);
        }
    }

    private static void swap(String[] a, int i, int j) {
        String t = a[i];
        a[i] = a[j];
        a[j] = t;
    }

    private String nextUri() {
        if (this.index >= this.uris.length) {
            this.index = 0;
        }
        return this.uris[this.index++];
    }

    @Benchmark
    public ByteBuf oldEncoder() throws Exception {
        ByteBuf buffer = Unpooled.buffer((int)100);
        try {
            this.encoderOld.encodeInitialLine(buffer, (HttpRequest)new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, this.nextUri()));
            ByteBuf byteBuf = buffer;
            return byteBuf;
        }
        finally {
            buffer.release();
        }
    }

    @Benchmark
    public ByteBuf newEncoder() throws Exception {
        ByteBuf buffer = Unpooled.buffer((int)100);
        try {
            this.encoderNew.encodeInitialLine(buffer, (HttpRequest)new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, this.nextUri()));
            ByteBuf byteBuf = buffer;
            return byteBuf;
        }
        finally {
            buffer.release();
        }
    }

    private static class OldHttpRequestEncoder
    extends HttpObjectEncoder<HttpRequest> {
        private static final byte[] CRLF = new byte[]{13, 10};
        private static final char SLASH = '/';
        private static final char QUESTION_MARK = '?';

        private OldHttpRequestEncoder() {
        }

        public boolean acceptOutboundMessage(Object msg) throws Exception {
            return super.acceptOutboundMessage(msg) && !(msg instanceof HttpResponse);
        }

        protected void encodeInitialLine(ByteBuf buf, HttpRequest request) throws Exception {
            AsciiString method = request.method().asciiName();
            ByteBufUtil.copy((AsciiString)method, (int)method.arrayOffset(), (ByteBuf)buf, (int)method.length());
            buf.writeByte(32);
            String uri = request.uri();
            if (uri.isEmpty()) {
                uri = uri + '/';
            } else {
                int start = uri.indexOf("://");
                if (start != -1 && uri.charAt(0) != '/') {
                    int startIndex = start + 3;
                    int index = uri.indexOf(63, startIndex);
                    if (index == -1) {
                        if (uri.lastIndexOf(47) <= startIndex) {
                            uri = uri + '/';
                        }
                    } else if (uri.lastIndexOf(47, index) <= startIndex) {
                        int len = uri.length();
                        StringBuilder sb = new StringBuilder(len + 1);
                        sb.append(uri, 0, index).append('/').append(uri, index, len);
                        uri = sb.toString();
                    }
                }
            }
            buf.writeBytes(uri.getBytes(CharsetUtil.UTF_8));
            buf.writeByte(32);
            request.protocolVersion().encode(buf);
            buf.writeBytes(CRLF);
        }
    }
}

