/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.concurrent;

import io.netty.channel.DefaultEventLoop;
import io.netty.channel.EventLoop;
import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;

@State(value=Scope.Benchmark)
public class ScheduledFutureTaskBenchmark
extends AbstractMicrobenchmark {
    static final EventLoop executor = new DefaultEventLoop();

    @TearDown(value=Level.Trial)
    public void stop() throws Exception {
        executor.shutdownGracefully().syncUninterruptibly();
    }

    @Benchmark
    public Future<?> cancelInOrder(final FuturesHolder futuresHolder) {
        return executor.submit(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < futuresHolder.num; ++i) {
                    futuresHolder.futures.get(i).cancel(false);
                }
            }
        }).syncUninterruptibly();
    }

    @Benchmark
    public Future<?> cancelInReverseOrder(final FuturesHolder futuresHolder) {
        return executor.submit(new Runnable(){

            @Override
            public void run() {
                for (int i = futuresHolder.num - 1; i >= 0; --i) {
                    futuresHolder.futures.get(i).cancel(false);
                }
            }
        }).syncUninterruptibly();
    }

    @State(value=Scope.Thread)
    public static class FuturesHolder {
        private static final Callable<Void> NO_OP = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                return null;
            }
        };
        @Param(value={"100", "1000", "10000", "100000"})
        int num;
        final List<ScheduledFuture<Void>> futures = new ArrayList<ScheduledFuture<Void>>();

        @Setup(value=Level.Invocation)
        public void reset() {
            this.futures.clear();
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    for (int i = 1; i <= FuturesHolder.this.num; ++i) {
                        FuturesHolder.this.futures.add((ScheduledFuture<Void>)executor.schedule(NO_OP, (long)i, TimeUnit.HOURS));
                    }
                }
            }).syncUninterruptibly();
        }
    }
}

