/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.internal.PlatformDependent;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;

@Threads(value=1)
@Warmup(iterations=3)
@Measurement(iterations=3)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@State(value=Scope.Benchmark)
public class HttpPostDecoderBenchmark
extends AbstractMicrobenchmark {
    @Param(value={"false", "true"})
    public boolean direct;
    private ByteBuf buf;
    private HttpRequest request;

    @Setup
    public void setUp() {
        this.request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/post");
        this.request.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/x-www-form-urlencoded");
        this.buf = this.direct ? Unpooled.directBuffer() : Unpooled.buffer();
        for (int i = 0; i < 100; ++i) {
            if (i != 0) {
                this.buf.writeByte(38);
            }
            ByteBufUtil.writeAscii((ByteBuf)this.buf, (CharSequence)("form-field-" + i));
            this.buf.writeByte(61);
            ByteBufUtil.writeAscii((ByteBuf)this.buf, (CharSequence)HttpPostDecoderBenchmark.randomString());
        }
    }

    private static CharSequence randomString() {
        Random rng = PlatformDependent.threadLocalRandom();
        int len = 4 + rng.nextInt(110);
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            String chars = "_-0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJLKMNOPQRSTUVWXYZ";
            sb.append(chars.charAt(rng.nextInt(chars.length())));
        }
        return sb;
    }

    @Benchmark
    public List<InterfaceHttpData> decode() {
        HttpPostRequestDecoder decoder = new HttpPostRequestDecoder(this.request);
        DefaultLastHttpContent content = new DefaultLastHttpContent(this.buf.duplicate());
        decoder.offer((HttpContent)content);
        return decoder.getBodyHttpDatas();
    }
}

