/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.AsciiString;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.CompilerControl;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@State(value=Scope.Benchmark)
@Warmup(iterations=10, time=200, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=200, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class Http2PseudoHeadersLookupBenchmark
extends AbstractMicrobenchmark {
    @Param(value={"true", "false"})
    public boolean same;
    private AsciiString[] asciiStrings;
    private String[] strings;
    private DefaultHttp2Headers headers;

    @Setup
    public void init() {
        Http2Headers.PseudoHeaderName[] pseudoHeaderNames = Http2Headers.PseudoHeaderName.values();
        this.asciiStrings = new AsciiString[pseudoHeaderNames.length];
        this.strings = new String[pseudoHeaderNames.length];
        for (int i = 0; i < pseudoHeaderNames.length; ++i) {
            Http2Headers.PseudoHeaderName pseudoHeaderName = pseudoHeaderNames[i];
            this.asciiStrings[i] = this.same ? pseudoHeaderName.value() : new AsciiString(pseudoHeaderName.value().array(), true);
            byte[] chars = this.asciiStrings[i].array();
            this.strings[i] = this.same ? pseudoHeaderName.value().toString() : new String(chars, 0, 0, chars.length);
            this.asciiStrings[i].hashCode();
            pseudoHeaderName.hashCode();
            pseudoHeaderName.toString().hashCode();
            this.strings[i].hashCode();
        }
        this.headers = new DefaultHttp2Headers();
    }

    @Benchmark
    @CompilerControl(value=CompilerControl.Mode.DONT_INLINE)
    public void getAsciiStringPseudoHeader(Blackhole bh) {
        for (AsciiString asciiString : this.asciiStrings) {
            bh.consume((Object)Http2Headers.PseudoHeaderName.getPseudoHeader((AsciiString)asciiString));
        }
    }

    @Benchmark
    @CompilerControl(value=CompilerControl.Mode.DONT_INLINE)
    public void getStringPseudoHeader(Blackhole bh) {
        for (String string : this.strings) {
            bh.consume((Object)Http2Headers.PseudoHeaderName.getPseudoHeader((CharSequence)string));
        }
    }

    @Benchmark
    @CompilerControl(value=CompilerControl.Mode.DONT_INLINE)
    public void addAsciiStringInHttp2Headers(Blackhole bh) {
        DefaultHttp2Headers headers = this.headers;
        for (AsciiString asciiString : this.asciiStrings) {
            boolean isPseudoHeader;
            boolean hasPrefix = Http2Headers.PseudoHeaderName.hasPseudoHeaderFormat((CharSequence)asciiString);
            if (!hasPrefix || !(isPseudoHeader = Http2Headers.PseudoHeaderName.isPseudoHeader((AsciiString)asciiString))) continue;
            bh.consume((Object)headers.add((Object)asciiString, (Object)"0"));
            headers.clear();
        }
    }

    @Benchmark
    @CompilerControl(value=CompilerControl.Mode.DONT_INLINE)
    public void addStringInHttp2Headers(Blackhole bh) {
        DefaultHttp2Headers headers = this.headers;
        for (String asciiString : this.strings) {
            boolean isPseudoHeader;
            boolean hasPrefix = Http2Headers.PseudoHeaderName.hasPseudoHeaderFormat((CharSequence)asciiString);
            if (!hasPrefix || !(isPseudoHeader = Http2Headers.PseudoHeaderName.isPseudoHeader((String)asciiString))) continue;
            bh.consume((Object)headers.add((Object)asciiString, (Object)"0"));
            headers.clear();
        }
    }
}

