/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.socksproxy;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.example.socksproxy.SocksServerConnectHandler;
import io.netty.example.socksproxy.SocksServerUtils;
import io.netty.handler.codec.socksx.SocksMessage;
import io.netty.handler.codec.socksx.v4.Socks4CommandRequest;
import io.netty.handler.codec.socksx.v4.Socks4CommandType;
import io.netty.handler.codec.socksx.v5.DefaultSocks5InitialResponse;
import io.netty.handler.codec.socksx.v5.DefaultSocks5PasswordAuthResponse;
import io.netty.handler.codec.socksx.v5.DefaultSocks5PrivateAuthResponse;
import io.netty.handler.codec.socksx.v5.Socks5AuthMethod;
import io.netty.handler.codec.socksx.v5.Socks5CommandRequest;
import io.netty.handler.codec.socksx.v5.Socks5CommandRequestDecoder;
import io.netty.handler.codec.socksx.v5.Socks5CommandType;
import io.netty.handler.codec.socksx.v5.Socks5InitialRequest;
import io.netty.handler.codec.socksx.v5.Socks5PasswordAuthRequest;
import io.netty.handler.codec.socksx.v5.Socks5PasswordAuthStatus;
import io.netty.handler.codec.socksx.v5.Socks5PrivateAuthRequest;
import io.netty.handler.codec.socksx.v5.Socks5PrivateAuthStatus;

@ChannelHandler.Sharable
public final class SocksServerHandler
extends SimpleChannelInboundHandler<SocksMessage> {
    public static final SocksServerHandler INSTANCE = new SocksServerHandler();

    private SocksServerHandler() {
    }

    public void channelRead0(ChannelHandlerContext ctx, SocksMessage socksRequest) throws Exception {
        switch (socksRequest.version()) {
            case SOCKS4a: {
                Socks4CommandRequest socksV4CmdRequest = (Socks4CommandRequest)socksRequest;
                if (socksV4CmdRequest.type() == Socks4CommandType.CONNECT) {
                    ctx.pipeline().addLast(new ChannelHandler[]{new SocksServerConnectHandler()});
                    ctx.pipeline().remove((ChannelHandler)this);
                    ctx.fireChannelRead((Object)socksRequest);
                    break;
                }
                ctx.close();
                break;
            }
            case SOCKS5: {
                if (socksRequest instanceof Socks5InitialRequest) {
                    ctx.pipeline().addFirst(new ChannelHandler[]{new Socks5CommandRequestDecoder()});
                    ctx.write((Object)new DefaultSocks5InitialResponse(Socks5AuthMethod.NO_AUTH));
                    break;
                }
                if (socksRequest instanceof Socks5PasswordAuthRequest) {
                    ctx.pipeline().addFirst(new ChannelHandler[]{new Socks5CommandRequestDecoder()});
                    ctx.write((Object)new DefaultSocks5PasswordAuthResponse(Socks5PasswordAuthStatus.SUCCESS));
                    break;
                }
                if (socksRequest instanceof Socks5PrivateAuthRequest) {
                    ctx.pipeline().addFirst(new ChannelHandler[]{new Socks5CommandRequestDecoder()});
                    ctx.write((Object)new DefaultSocks5PrivateAuthResponse(Socks5PrivateAuthStatus.SUCCESS));
                    break;
                }
                if (socksRequest instanceof Socks5CommandRequest) {
                    Socks5CommandRequest socks5CmdRequest = (Socks5CommandRequest)socksRequest;
                    if (socks5CmdRequest.type() == Socks5CommandType.CONNECT) {
                        ctx.pipeline().addLast(new ChannelHandler[]{new SocksServerConnectHandler()});
                        ctx.pipeline().remove((ChannelHandler)this);
                        ctx.fireChannelRead((Object)socksRequest);
                        break;
                    }
                    ctx.close();
                    break;
                }
                ctx.close();
                break;
            }
            case UNKNOWN: {
                ctx.close();
            }
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable throwable) {
        throwable.printStackTrace();
        SocksServerUtils.closeOnFlush(ctx.channel());
    }
}

