/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.ocsp;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.nio.NioIoHandler;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.ocsp.OcspClientHandler;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.math.BigInteger;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.SingleResp;

public class OcspClientExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (!OpenSsl.isAvailable()) {
            throw new IllegalStateException("OpenSSL is not available!");
        }
        if (!OpenSsl.isOcspSupported()) {
            throw new IllegalStateException("OCSP is not supported!");
        }
        String host = "www.wikipedia.org";
        ReferenceCountedOpenSslContext context = (ReferenceCountedOpenSslContext)SslContextBuilder.forClient().sslProvider(SslProvider.OPENSSL).enableOcsp(true).build();
        try {
            MultiThreadIoEventLoopGroup group = new MultiThreadIoEventLoopGroup(NioIoHandler.newFactory());
            try {
                Promise promise = group.next().newPromise();
                Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channel(NioSocketChannel.class)).group((EventLoopGroup)group)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)5000)).handler(OcspClientExample.newClientHandler(context, host, (Promise<FullHttpResponse>)promise));
                try (Channel channel = bootstrap.connect(host, 443).syncUninterruptibly().channel();){
                    FullHttpResponse response = (FullHttpResponse)promise.get();
                    ReferenceCountUtil.release((Object)response);
                }
            }
            finally {
                group.shutdownGracefully();
            }
        }
        finally {
            context.release();
        }
    }

    private static ChannelInitializer<Channel> newClientHandler(final ReferenceCountedOpenSslContext context, final String host, final Promise<FullHttpResponse> promise) {
        return new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                SslHandler sslHandler = context.newHandler(ch.alloc());
                ReferenceCountedOpenSslEngine engine = (ReferenceCountedOpenSslEngine)sslHandler.engine();
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast(new ChannelHandler[]{sslHandler});
                pipeline.addLast(new ChannelHandler[]{new ExampleOcspClientHandler(engine)});
                pipeline.addLast(new ChannelHandler[]{new HttpClientCodec()});
                pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(0x100000)});
                pipeline.addLast(new ChannelHandler[]{new HttpClientHandler(host, (Promise<FullHttpResponse>)promise)});
            }

            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                if (!promise.isDone()) {
                    promise.tryFailure((Throwable)new IllegalStateException("Connection closed and Promise was not done."));
                }
                ctx.fireChannelInactive();
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                if (!promise.tryFailure(cause)) {
                    ctx.fireExceptionCaught(cause);
                }
            }
        };
    }

    private static class ExampleOcspClientHandler
    extends OcspClientHandler {
        ExampleOcspClientHandler(ReferenceCountedOpenSslEngine engine) {
            super(engine);
        }

        protected boolean verify(ChannelHandlerContext ctx, ReferenceCountedOpenSslEngine engine) throws Exception {
            byte[] staple = engine.getOcspResponse();
            if (staple == null) {
                throw new IllegalStateException("Server didn't provide an OCSP staple!");
            }
            OCSPResp response = new OCSPResp(staple);
            if (response.getStatus() != 0) {
                return false;
            }
            SSLSession session = engine.getSession();
            X509Certificate[] chain = session.getPeerCertificateChain();
            BigInteger certSerial = chain[0].getSerialNumber();
            BasicOCSPResp basicResponse = (BasicOCSPResp)response.getResponseObject();
            SingleResp first = basicResponse.getResponses()[0];
            CertificateStatus status = first.getCertStatus();
            BigInteger ocspSerial = first.getCertID().getSerialNumber();
            String message = "OCSP status of " + ctx.channel().remoteAddress() + "\n  Status: " + (status == CertificateStatus.GOOD ? "Good" : status) + "\n  This Update: " + first.getThisUpdate() + "\n  Next Update: " + first.getNextUpdate() + "\n  Cert Serial: " + certSerial + "\n  OCSP Serial: " + ocspSerial;
            System.out.println(message);
            return status == CertificateStatus.GOOD && certSerial.equals(ocspSerial);
        }
    }

    private static class HttpClientHandler
    extends ChannelInboundHandlerAdapter {
        private final String host;
        private final Promise<FullHttpResponse> promise;

        HttpClientHandler(String host, Promise<FullHttpResponse> promise) {
            this.host = host;
            this.promise = promise;
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/", Unpooled.EMPTY_BUFFER);
            request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)this.host);
            request.headers().set((CharSequence)HttpHeaderNames.USER_AGENT, (Object)"netty-ocsp-example/1.0");
            ctx.writeAndFlush((Object)request).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
            ctx.fireChannelActive();
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            if (!this.promise.isDone()) {
                this.promise.tryFailure((Throwable)new IllegalStateException("Connection closed and Promise was not done."));
            }
            ctx.fireChannelInactive();
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (msg instanceof FullHttpResponse) {
                if (!this.promise.trySuccess((Object)((FullHttpResponse)msg))) {
                    ReferenceCountUtil.release((Object)msg);
                }
                return;
            }
            ctx.fireChannelRead(msg);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (!this.promise.tryFailure(cause)) {
                ctx.fireExceptionCaught(cause);
            }
        }
    }
}

