/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.spdy.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.nio.NioIoHandler;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.example.spdy.server.SpdyServerInitializer;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.pkitesting.CertificateBuilder;
import io.netty.pkitesting.X509Bundle;
import javax.net.ssl.KeyManagerFactory;

public final class SpdyServer {
    static final int PORT = Integer.parseInt(System.getProperty("port", "8443"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        X509Bundle ssc = new CertificateBuilder().subject("cn=localhost").setIsCertificateAuthority(true).buildSelfSigned();
        SslContext sslCtx = SslContextBuilder.forServer((KeyManagerFactory)ssc.toKeyManagerFactory()).applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"spdy/3.1", "http/1.1"})).build();
        MultiThreadIoEventLoopGroup group = new MultiThreadIoEventLoopGroup(NioIoHandler.newFactory());
        try {
            ServerBootstrap b = new ServerBootstrap();
            b.option(ChannelOption.SO_BACKLOG, (Object)1024);
            ((ServerBootstrap)((ServerBootstrap)b.group((EventLoopGroup)group).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new SpdyServerInitializer(sslCtx));
            Channel ch = b.bind(PORT).sync().channel();
            System.err.println("Open your SPDY-enabled web browser and navigate to https://127.0.0.1:" + PORT + '/');
            System.err.println("If using Chrome browser, check your SPDY sessions at chrome://net-internals/#spdy");
            ch.closeFuture().sync();
        }
        finally {
            group.shutdownGracefully();
        }
    }
}

