/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.stomp.websocket;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.example.stomp.websocket.StompVersion;
import io.netty.example.stomp.websocket.StompWebSocketClientPageHandler;
import io.netty.example.stomp.websocket.StompWebSocketProtocolCodec;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.util.internal.ObjectUtil;

public class StompWebSocketChatServerInitializer
extends ChannelInitializer<SocketChannel> {
    private final String chatPath;
    private final StompWebSocketProtocolCodec stompWebSocketProtocolCodec;

    public StompWebSocketChatServerInitializer(String chatPath) {
        this.chatPath = (String)ObjectUtil.checkNotNull((Object)chatPath, (String)"chatPath");
        this.stompWebSocketProtocolCodec = new StompWebSocketProtocolCodec();
    }

    protected void initChannel(SocketChannel channel) throws Exception {
        channel.pipeline().addLast(new ChannelHandler[]{new HttpServerCodec()}).addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)}).addLast(new ChannelHandler[]{StompWebSocketClientPageHandler.INSTANCE}).addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler(this.chatPath, StompVersion.SUB_PROTOCOLS)}).addLast(new ChannelHandler[]{this.stompWebSocketProtocolCodec});
    }
}

