/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http2.helloworld.client;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.example.http2.helloworld.client.Http2SettingsHandler;
import io.netty.example.http2.helloworld.client.HttpResponseHandler;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DelegatingDecompressorFrameListener;
import io.netty.handler.codec.http2.Http2ClientUpgradeCodec;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandler;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.InboundHttp2ToHttpAdapterBuilder;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.SslContext;

public class Http2ClientInitializer
extends ChannelInitializer<SocketChannel> {
    private static final Http2FrameLogger logger = new Http2FrameLogger(LogLevel.INFO, Http2ClientInitializer.class);
    private final SslContext sslCtx;
    private final int maxContentLength;
    private HttpToHttp2ConnectionHandler connectionHandler;
    private HttpResponseHandler responseHandler;
    private Http2SettingsHandler settingsHandler;

    public Http2ClientInitializer(SslContext sslCtx, int maxContentLength) {
        this.sslCtx = sslCtx;
        this.maxContentLength = maxContentLength;
    }

    public void initChannel(SocketChannel ch) throws Exception {
        DefaultHttp2Connection connection = new DefaultHttp2Connection(false);
        this.connectionHandler = new HttpToHttp2ConnectionHandlerBuilder().frameListener((Http2FrameListener)new DelegatingDecompressorFrameListener((Http2Connection)connection, (Http2FrameListener)new InboundHttp2ToHttpAdapterBuilder((Http2Connection)connection).maxContentLength(this.maxContentLength).propagateSettings(true).build())).frameLogger(logger).connection((Http2Connection)connection).build();
        this.responseHandler = new HttpResponseHandler();
        this.settingsHandler = new Http2SettingsHandler(ch.newPromise());
        if (this.sslCtx != null) {
            this.configureSsl(ch);
        } else {
            this.configureClearText(ch);
        }
    }

    public HttpResponseHandler responseHandler() {
        return this.responseHandler;
    }

    public Http2SettingsHandler settingsHandler() {
        return this.settingsHandler;
    }

    protected void configureEndOfPipeline(ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{this.settingsHandler, this.responseHandler});
    }

    private void configureSsl(SocketChannel ch) {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast(new ChannelHandler[]{this.sslCtx.newHandler(ch.alloc())});
        pipeline.addLast(new ChannelHandler[]{new ApplicationProtocolNegotiationHandler(""){

            protected void configurePipeline(ChannelHandlerContext ctx, String protocol) {
                if ("h2".equals(protocol)) {
                    ChannelPipeline p = ctx.pipeline();
                    p.addLast(new ChannelHandler[]{Http2ClientInitializer.this.connectionHandler});
                    Http2ClientInitializer.this.configureEndOfPipeline(p);
                    return;
                }
                ctx.close();
                throw new IllegalStateException("unknown protocol: " + protocol);
            }
        }});
    }

    private void configureClearText(SocketChannel ch) {
        HttpClientCodec sourceCodec = new HttpClientCodec();
        Http2ClientUpgradeCodec upgradeCodec = new Http2ClientUpgradeCodec((Http2ConnectionHandler)this.connectionHandler);
        HttpClientUpgradeHandler upgradeHandler = new HttpClientUpgradeHandler((HttpClientUpgradeHandler.SourceCodec)sourceCodec, (HttpClientUpgradeHandler.UpgradeCodec)upgradeCodec, 65536);
        ch.pipeline().addLast(new ChannelHandler[]{sourceCodec, upgradeHandler, new UpgradeRequestHandler(), new UserEventLogger()});
    }

    private static class UserEventLogger
    extends ChannelInboundHandlerAdapter {
        private UserEventLogger() {
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            System.out.println("User Event Triggered: " + evt);
            ctx.fireUserEventTriggered(evt);
        }
    }

    private final class UpgradeRequestHandler
    extends ChannelInboundHandlerAdapter {
        private UpgradeRequestHandler() {
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            DefaultFullHttpRequest upgradeRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/");
            ctx.writeAndFlush((Object)upgradeRequest);
            ctx.fireChannelActive();
            ctx.pipeline().remove((ChannelHandler)this);
            Http2ClientInitializer.this.configureEndOfPipeline(ctx.pipeline());
        }
    }
}

