/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.worldclock;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.example.worldclock.WorldClockProtocol;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WorldClockServerHandler
extends SimpleChannelInboundHandler<WorldClockProtocol.Locations> {
    private static final Logger logger = Logger.getLogger(WorldClockServerHandler.class.getName());

    public void channelRead0(ChannelHandlerContext ctx, WorldClockProtocol.Locations locations) throws Exception {
        long currentTime = System.currentTimeMillis();
        WorldClockProtocol.LocalTimes.Builder builder = WorldClockProtocol.LocalTimes.newBuilder();
        for (WorldClockProtocol.Location l : locations.getLocationList()) {
            TimeZone tz = TimeZone.getTimeZone(WorldClockServerHandler.toString(l.getContinent()) + '/' + l.getCity());
            Calendar calendar = Calendar.getInstance(tz);
            calendar.setTimeInMillis(currentTime);
            builder.addLocalTime(WorldClockProtocol.LocalTime.newBuilder().setYear(calendar.get(1)).setMonth(calendar.get(2) + 1).setDayOfMonth(calendar.get(5)).setDayOfWeek(WorldClockProtocol.DayOfWeek.valueOf(calendar.get(7))).setHour(calendar.get(11)).setMinute(calendar.get(12)).setSecond(calendar.get(13)).build());
        }
        ctx.write((Object)builder.build());
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.log(Level.WARNING, "Unexpected exception from downstream.", cause);
        ctx.close();
    }

    private static String toString(WorldClockProtocol.Continent c) {
        return c.name().charAt(0) + c.name().toLowerCase().substring(1);
    }
}

