/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.smtp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.AsciiString;
import io.netty.util.internal.ObjectUtil;
import java.util.HashMap;
import java.util.Map;

public final class SmtpCommand {
    public static final SmtpCommand EHLO = new SmtpCommand(new AsciiString((CharSequence)"EHLO"), false);
    public static final SmtpCommand HELO = new SmtpCommand(new AsciiString((CharSequence)"HELO"), false);
    public static final SmtpCommand MAIL = new SmtpCommand(new AsciiString((CharSequence)"MAIL"), false);
    public static final SmtpCommand RCPT = new SmtpCommand(new AsciiString((CharSequence)"RCPT"), false);
    public static final SmtpCommand DATA = new SmtpCommand(new AsciiString((CharSequence)"DATA"), true);
    public static final SmtpCommand NOOP = new SmtpCommand(new AsciiString((CharSequence)"NOOP"), false);
    public static final SmtpCommand RSET = new SmtpCommand(new AsciiString((CharSequence)"RSET"), false);
    public static final SmtpCommand EXPN = new SmtpCommand(new AsciiString((CharSequence)"EXPN"), false);
    public static final SmtpCommand VRFY = new SmtpCommand(new AsciiString((CharSequence)"VRFY"), false);
    public static final SmtpCommand HELP = new SmtpCommand(new AsciiString((CharSequence)"HELP"), false);
    public static final SmtpCommand QUIT = new SmtpCommand(new AsciiString((CharSequence)"QUIT"), false);
    private static final CharSequence DATA_CMD = new AsciiString((CharSequence)"DATA");
    private static final Map<CharSequence, SmtpCommand> COMMANDS = new HashMap<CharSequence, SmtpCommand>();
    private final AsciiString name;
    private final boolean contentExpected;
    private int hashCode;

    public static SmtpCommand valueOf(CharSequence commandName) {
        SmtpCommand command = COMMANDS.get(commandName);
        if (command != null) {
            return command;
        }
        return new SmtpCommand(AsciiString.of((CharSequence)((CharSequence)ObjectUtil.checkNotNull((Object)commandName, (String)"commandName"))), AsciiString.contentEqualsIgnoreCase((CharSequence)commandName, (CharSequence)DATA_CMD));
    }

    private SmtpCommand(AsciiString name, boolean contentExpected) {
        this.name = name;
        this.contentExpected = contentExpected;
    }

    public AsciiString name() {
        return this.name;
    }

    void encode(ByteBuf buffer) {
        ByteBufUtil.writeAscii((ByteBuf)buffer, (CharSequence)this.name());
    }

    boolean isContentExpected() {
        return this.contentExpected;
    }

    public int hashCode() {
        if (this.hashCode != -1) {
            this.hashCode = AsciiString.hashCode((CharSequence)this.name);
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SmtpCommand)) {
            return false;
        }
        return this.name.contentEqualsIgnoreCase((CharSequence)((SmtpCommand)obj).name());
    }

    public String toString() {
        return "SmtpCommand{name=" + this.name + ", contentExpected=" + this.contentExpected + ", hashCode=" + this.hashCode + '}';
    }

    static {
        COMMANDS.put((CharSequence)EHLO.name(), EHLO);
        COMMANDS.put((CharSequence)HELO.name(), HELO);
        COMMANDS.put((CharSequence)MAIL.name(), MAIL);
        COMMANDS.put((CharSequence)RCPT.name(), RCPT);
        COMMANDS.put((CharSequence)DATA.name(), DATA);
        COMMANDS.put((CharSequence)NOOP.name(), NOOP);
        COMMANDS.put((CharSequence)RSET.name(), RSET);
        COMMANDS.put((CharSequence)EXPN.name(), EXPN);
        COMMANDS.put((CharSequence)VRFY.name(), VRFY);
        COMMANDS.put((CharSequence)HELP.name(), HELP);
        COMMANDS.put((CharSequence)QUIT.name(), QUIT);
    }
}

