/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2MaxRstFrameListener;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class Http2MaxRstFrameListenerTest {
    @Mock
    private Http2FrameListener frameListener;
    @Mock
    private ChannelHandlerContext ctx;
    private Http2MaxRstFrameListener listener;

    @BeforeEach
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testMaxRstFramesReached() throws Http2Exception {
        this.listener = new Http2MaxRstFrameListener(this.frameListener, 1, 10);
        this.listener.onRstStreamRead(this.ctx, 1, Http2Error.STREAM_CLOSED.code());
        Http2Exception ex = (Http2Exception)Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                Http2MaxRstFrameListenerTest.this.listener.onRstStreamRead(Http2MaxRstFrameListenerTest.this.ctx, 2, Http2Error.STREAM_CLOSED.code());
            }
        });
        Assertions.assertEquals((Object)Http2Error.ENHANCE_YOUR_CALM, (Object)ex.error());
        ((Http2FrameListener)Mockito.verify((Object)this.frameListener, (VerificationMode)Mockito.times((int)1))).onRstStreamRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), ArgumentMatchers.anyInt(), Mockito.eq((long)Http2Error.STREAM_CLOSED.code()));
    }

    @Test
    public void testRstFrames() throws Exception {
        this.listener = new Http2MaxRstFrameListener(this.frameListener, 1, 1);
        this.listener.onRstStreamRead(this.ctx, 1, Http2Error.STREAM_CLOSED.code());
        Thread.sleep(1100L);
        this.listener.onRstStreamRead(this.ctx, 1, Http2Error.STREAM_CLOSED.code());
        ((Http2FrameListener)Mockito.verify((Object)this.frameListener, (VerificationMode)Mockito.times((int)2))).onRstStreamRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), ArgumentMatchers.anyInt(), Mockito.eq((long)Http2Error.STREAM_CLOSED.code()));
    }
}

