/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.ohttp;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import io.netty.incubator.codec.hpke.AEAD;
import io.netty.incubator.codec.hpke.KDF;
import io.netty.incubator.codec.hpke.KEM;
import java.util.Objects;

public final class OHttpCiphersuite {
    static final int ENCODED_LENGTH = 7;
    private final byte keyId;
    private final KEM kem;
    private final KDF kdf;
    private final AEAD aead;

    public OHttpCiphersuite(byte keyId, KEM kem, KDF kdf, AEAD aead) {
        this.keyId = keyId;
        this.kem = Objects.requireNonNull(kem, "kem");
        this.kdf = Objects.requireNonNull(kdf, "kdf");
        this.aead = Objects.requireNonNull(aead, "ahead");
    }

    public int responseNonceLength() {
        return Math.max(this.aead.nk(), this.aead.nn());
    }

    public int encapsulatedKeyLength() {
        return this.kem.nenc();
    }

    public byte keyId() {
        return this.keyId;
    }

    public KEM kem() {
        return this.kem;
    }

    public KDF kdf() {
        return this.kdf;
    }

    public AEAD aead() {
        return this.aead;
    }

    void encode(ByteBuf out) {
        out.writeByte((int)this.keyId);
        out.writeShort((int)this.kem.id());
        out.writeShort((int)this.kdf.id());
        out.writeShort((int)this.aead.id());
    }

    static OHttpCiphersuite decode(ByteBuf in) {
        if (in.readableBytes() < 7) {
            return null;
        }
        try {
            byte keyId = in.readByte();
            short kemId = in.readShort();
            short kdfId = in.readShort();
            short aeadId = in.readShort();
            return new OHttpCiphersuite(keyId, KEM.forId((short)kemId), KDF.forId((short)kdfId), AEAD.forId((short)aeadId));
        }
        catch (Exception e) {
            throw new DecoderException("invalid ciphersuite", (Throwable)e);
        }
    }

    public String toString() {
        return "OHttpCiphersuite{id=" + Byte.toUnsignedInt(this.keyId) + ", kem=" + this.kem + ", kdf=" + this.kdf + ", aead=" + this.aead + "}";
    }
}

