/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.ohttp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.incubator.codec.hpke.CryptoException;
import io.netty.incubator.codec.ohttp.OHttpChunkFramer;
import io.netty.incubator.codec.ohttp.OHttpConstants;
import io.netty.incubator.codec.ohttp.OHttpVersion;
import io.netty.util.AsciiString;
import java.nio.charset.StandardCharsets;
import java.util.List;

public final class OHttpVersionDraft
implements OHttpVersion {
    public static final OHttpVersion INSTANCE = new OHttpVersionDraft();
    private static final byte[] REQUEST_EXPORT_CONTEXT = "message/bhttp request".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] RESPONSE_EXPORT_CONTEXT = "message/bhttp response".getBytes(StandardCharsets.US_ASCII);

    private OHttpVersionDraft() {
    }

    @Override
    public byte[] requestExportContext() {
        return (byte[])REQUEST_EXPORT_CONTEXT.clone();
    }

    @Override
    public byte[] responseExportContext() {
        return (byte[])RESPONSE_EXPORT_CONTEXT.clone();
    }

    @Override
    public boolean useFinalAad() {
        return false;
    }

    @Override
    public AsciiString requestContentType() {
        return OHttpConstants.REQUEST_CONTENT_TYPE;
    }

    @Override
    public AsciiString responseContentType() {
        return OHttpConstants.RESPONSE_CONTENT_TYPE;
    }

    @Override
    public void parse(ByteBufAllocator alloc, ByteBuf in, boolean completeBodyReceived, OHttpChunkFramer.Decoder decoder, List<Object> out) throws CryptoException {
        if (completeBodyReceived) {
            if (decoder.isPrefixNeeded() && !decoder.decodePrefix(alloc, in)) {
                throw new CorruptedFrameException("Prefix is truncated");
            }
            decoder.decodeChunk(alloc, in, in.readableBytes(), true, out);
        }
    }

    @Override
    public void serialize(ByteBufAllocator alloc, HttpObject msg, OHttpChunkFramer.Encoder<HttpObject> encoder, ByteBuf out) throws CryptoException {
        if (!(msg instanceof LastHttpContent)) {
            throw new EncoderException("OHTTP version only supports FullHttpMessage");
        }
        if (encoder.isPrefixNeeded()) {
            encoder.encodePrefix(alloc, out);
        }
        encoder.encodeChunk(alloc, msg, out);
    }
}

