/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.ohttp;

import io.netty.buffer.ByteBuf;
import io.netty.incubator.codec.hpke.AsymmetricCipherKeyPair;
import io.netty.incubator.codec.hpke.CryptoDecryptContext;
import io.netty.incubator.codec.hpke.CryptoEncryptContext;
import io.netty.incubator.codec.hpke.HPKEContext;
import io.netty.incubator.codec.hpke.HPKERecipientContext;
import io.netty.incubator.codec.hpke.OHttpCryptoProvider;
import io.netty.incubator.codec.ohttp.OHttpCiphersuite;
import io.netty.incubator.codec.ohttp.OHttpCrypto;
import io.netty.incubator.codec.ohttp.OHttpCryptoConfiguration;
import java.security.SecureRandom;
import java.util.Objects;
import java.util.Random;

public final class OHttpCryptoReceiver
extends OHttpCrypto {
    private static final Random RAND = new SecureRandom();
    private final OHttpCryptoConfiguration configuration;
    private final HPKERecipientContext context;
    private final byte[] responseNonce;
    private final CryptoEncryptContext aead;

    public static Builder newBuilder() {
        return new Builder();
    }

    private OHttpCryptoReceiver(Builder builder) {
        this.configuration = Objects.requireNonNull(builder.configuration, "configuration");
        OHttpCiphersuite ciphersuite = Objects.requireNonNull(builder.ciphersuite, "ciphersuite");
        byte[] encapsulatedKey = Objects.requireNonNull(builder.encapsulatedKey, "encapsulatedKey");
        OHttpCryptoProvider provider = Objects.requireNonNull(builder.provider, "provider");
        AsymmetricCipherKeyPair keyPair = Objects.requireNonNull(builder.privateKey, "privateKey");
        if (builder.forcedResponseNonce == null) {
            this.responseNonce = new byte[ciphersuite.responseNonceLength()];
            RAND.nextBytes(this.responseNonce);
        } else {
            this.responseNonce = builder.forcedResponseNonce;
        }
        this.context = provider.setupHPKEBaseR(ciphersuite.kem(), ciphersuite.kdf(), ciphersuite.aead(), encapsulatedKey, keyPair, ciphersuite.createInfo(this.configuration.requestExportContext()));
        try {
            this.aead = ciphersuite.createResponseAEAD(provider, (HPKEContext)this.context, encapsulatedKey, this.responseNonce, this.configuration.responseExportContext());
        }
        catch (Throwable cause) {
            this.context.close();
            throw cause;
        }
    }

    public void writeResponseNonce(ByteBuf out) {
        out.writeBytes(this.responseNonce);
    }

    @Override
    protected CryptoEncryptContext encryptCrypto() {
        return this.aead;
    }

    @Override
    protected CryptoDecryptContext decryptCrypto() {
        return this.context;
    }

    @Override
    protected boolean useFinalAad() {
        return this.configuration.useFinalAad();
    }

    public static final class Builder {
        private OHttpCryptoProvider provider;
        private OHttpCryptoConfiguration configuration;
        private AsymmetricCipherKeyPair privateKey;
        private OHttpCiphersuite ciphersuite;
        private byte[] encapsulatedKey;
        private byte[] forcedResponseNonce;

        public Builder setOHttpCryptoProvider(OHttpCryptoProvider provider) {
            this.provider = provider;
            return this;
        }

        public Builder setConfiguration(OHttpCryptoConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder setSenderPrivateKey(AsymmetricCipherKeyPair privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public Builder setCiphersuite(OHttpCiphersuite value) {
            this.ciphersuite = value;
            return this;
        }

        public Builder setEncapsulatedKey(byte[] value) {
            this.encapsulatedKey = value;
            return this;
        }

        public Builder setForcedResponseNonce(byte[] value) {
            this.forcedResponseNonce = value;
            return this;
        }

        public OHttpCryptoReceiver build() {
            return new OHttpCryptoReceiver(this);
        }

        private Builder() {
        }
    }
}

