/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.ohttp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.incubator.codec.hpke.CryptoDecryptContext;
import io.netty.incubator.codec.hpke.CryptoEncryptContext;
import io.netty.incubator.codec.hpke.CryptoException;
import java.nio.charset.StandardCharsets;

public abstract class OHttpCrypto
implements AutoCloseable {
    private static final ByteBuf EMPTY_HEAP = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[])new byte[0]).asReadOnly());
    private static final ByteBuf EMPTY_DIRECT = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.directBuffer().asReadOnly());
    private static final ByteBuf AAD_FINAL_HEAP = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[])"final".getBytes(StandardCharsets.US_ASCII)).asReadOnly());
    private static final ByteBuf AAD_FINAL_DIRECT = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.directBuffer((int)5).writeBytes("final".getBytes(StandardCharsets.US_ASCII)).asReadOnly());

    OHttpCrypto() {
    }

    private static ByteBuf aad(boolean isFinal, boolean preferDirect) {
        if (isFinal) {
            return preferDirect ? AAD_FINAL_DIRECT.duplicate() : AAD_FINAL_HEAP.duplicate();
        }
        return preferDirect ? EMPTY_DIRECT.duplicate() : EMPTY_HEAP.duplicate();
    }

    protected abstract CryptoEncryptContext encryptCrypto();

    protected abstract CryptoDecryptContext decryptCrypto();

    protected abstract boolean useFinalAad();

    public final void encrypt(ByteBufAllocator alloc, ByteBuf message, int messageLength, boolean isFinal, ByteBuf out) throws CryptoException {
        this.encryptCrypto().seal(alloc, OHttpCrypto.aad(isFinal && this.useFinalAad(), this.encryptCrypto().isDirectBufferPreferred()), message.slice(message.readerIndex(), messageLength), out);
        message.skipBytes(messageLength);
    }

    public final void decrypt(ByteBufAllocator alloc, ByteBuf message, int messageLength, boolean isFinal, ByteBuf out) throws CryptoException {
        this.decryptCrypto().open(alloc, OHttpCrypto.aad(isFinal && this.useFinalAad(), this.decryptCrypto().isDirectBufferPreferred()), message.slice(message.readerIndex(), messageLength), out);
        message.skipBytes(messageLength);
    }

    @Override
    public void close() {
        CryptoDecryptContext decryptContext;
        CryptoEncryptContext encryptContext = this.encryptCrypto();
        if (encryptContext != null) {
            encryptContext.close();
        }
        if ((decryptContext = this.decryptCrypto()) != null) {
            decryptContext.close();
        }
    }
}

