/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.ohttp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.DecoderException;
import io.netty.incubator.codec.hpke.AEAD;
import io.netty.incubator.codec.hpke.AEADContext;
import io.netty.incubator.codec.hpke.HPKEContext;
import io.netty.incubator.codec.hpke.KDF;
import io.netty.incubator.codec.hpke.KEM;
import io.netty.incubator.codec.hpke.OHttpCryptoProvider;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public final class OHttpCiphersuite {
    private static final int ENCODED_LENGTH = 7;
    private static final byte[] KEY_INFO = "key".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] NONCE_INFO = "nonce".getBytes(StandardCharsets.US_ASCII);
    private final byte keyId;
    private final KEM kem;
    private final KDF kdf;
    private final AEAD aead;

    public OHttpCiphersuite(byte keyId, KEM kem, KDF kdf, AEAD aead) {
        this.keyId = keyId;
        this.kem = Objects.requireNonNull(kem, "kem");
        this.kdf = Objects.requireNonNull(kdf, "kdf");
        this.aead = Objects.requireNonNull(aead, "ahead");
    }

    public int responseNonceLength() {
        return Math.max(this.aead.nk(), this.aead.nn());
    }

    public int encapsulatedKeyLength() {
        return this.kem.nenc();
    }

    public byte keyId() {
        return this.keyId;
    }

    public KEM kem() {
        return this.kem;
    }

    public KDF kdf() {
        return this.kdf;
    }

    public AEAD aead() {
        return this.aead;
    }

    void encode(ByteBuf out) {
        out.writeByte((int)this.keyId);
        out.writeShort((int)this.kem.id());
        out.writeShort((int)this.kdf.id());
        out.writeShort((int)this.aead.id());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] createInfo(byte[] requestExportContext) {
        byte[] ret = new byte[requestExportContext.length + 1 + 7];
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])ret);
        try {
            buf.writerIndex(0).writeBytes(requestExportContext).writeByte(0);
            this.encode(buf);
            byte[] byArray = ret;
            return byArray;
        }
        finally {
            buf.release();
        }
    }

    static OHttpCiphersuite decode(ByteBuf in) {
        if (in.readableBytes() < 7) {
            return null;
        }
        try {
            byte keyId = in.readByte();
            short kemId = in.readShort();
            short kdfId = in.readShort();
            short aeadId = in.readShort();
            return new OHttpCiphersuite(keyId, KEM.forId((short)kemId), KDF.forId((short)kdfId), AEAD.forId((short)aeadId));
        }
        catch (Exception e) {
            throw new DecoderException("invalid ciphersuite", (Throwable)e);
        }
    }

    AEADContext createResponseAEAD(OHttpCryptoProvider provider, HPKEContext context, byte[] enc, byte[] responseNonce, byte[] responseExportContext) {
        int secretLength = Math.max(this.aead.nk(), this.aead.nn());
        byte[] secret = context.export(responseExportContext, secretLength);
        byte[] salt = new byte[enc.length + responseNonce.length];
        System.arraycopy(enc, 0, salt, 0, enc.length);
        System.arraycopy(responseNonce, 0, salt, enc.length, responseNonce.length);
        byte[] prk = context.extract(salt, secret);
        byte[] aeadKey = context.expand(prk, KEY_INFO, this.aead.nk());
        byte[] aeadNonce = context.expand(prk, NONCE_INFO, this.aead.nn());
        return provider.setupAEAD(this.aead, aeadKey, aeadNonce);
    }

    public String toString() {
        return "OHttpCiphersuite{id=" + Byte.toUnsignedInt(this.keyId) + ", kem=" + this.kem + ", kdf=" + this.kdf + ", aead=" + this.aead + "}";
    }
}

