/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.ohttp;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import io.netty.incubator.codec.hpke.AsymmetricCipherKeyPair;
import io.netty.incubator.codec.hpke.CryptoDecryptContext;
import io.netty.incubator.codec.hpke.CryptoEncryptContext;
import io.netty.incubator.codec.hpke.HPKEContext;
import io.netty.incubator.codec.hpke.HPKERecipientContext;
import io.netty.incubator.codec.hpke.OHttpCryptoProvider;
import io.netty.incubator.codec.ohttp.OHttpCiphersuite;
import io.netty.incubator.codec.ohttp.OHttpCrypto;
import io.netty.incubator.codec.ohttp.OHttpCryptoConfiguration;
import io.netty.incubator.codec.ohttp.OHttpServerKeys;
import java.util.Objects;

public final class OHttpCryptoReceiver
extends OHttpCrypto {
    private final OHttpCryptoConfiguration configuration;
    private final HPKERecipientContext context;
    private final byte[] responseNonce;
    private final CryptoEncryptContext aead;

    public static Builder newBuilder() {
        return new Builder();
    }

    private OHttpCryptoReceiver(Builder builder) {
        this.configuration = Objects.requireNonNull(builder.configuration, "configuration");
        OHttpServerKeys serverKeys = Objects.requireNonNull(builder.serverKeys, "serverKeys");
        OHttpCiphersuite ciphersuite = Objects.requireNonNull(builder.ciphersuite, "ciphersuite");
        byte[] encapsulatedKey = Objects.requireNonNull(builder.encapsulatedKey, "encapsulatedKey");
        OHttpCryptoProvider provider = Objects.requireNonNull(builder.provider, "provider");
        AsymmetricCipherKeyPair keyPair = serverKeys.getKeyPair(ciphersuite);
        if (keyPair == null) {
            throw new DecoderException("ciphersuite not supported");
        }
        this.context = provider.setupHPKEBaseR(OHttpCryptoProvider.Mode.Base, ciphersuite.kem(), ciphersuite.kdf(), ciphersuite.aead(), encapsulatedKey, keyPair, ciphersuite.createInfo(this.configuration));
        this.responseNonce = builder.forcedResponseNonce == null ? builder.ciphersuite.createResponseNonce() : builder.forcedResponseNonce;
        this.aead = builder.ciphersuite.createResponseAead(provider, (HPKEContext)this.context, encapsulatedKey, this.responseNonce, this.configuration);
    }

    public void writeResponseNonce(ByteBuf out) {
        out.writeBytes(this.responseNonce);
    }

    @Override
    protected CryptoEncryptContext encryptCrypto() {
        return this.aead;
    }

    @Override
    protected CryptoDecryptContext decryptCrypto() {
        return this.context;
    }

    @Override
    protected OHttpCryptoConfiguration configuration() {
        return this.configuration;
    }

    public static final class Builder {
        private OHttpCryptoProvider provider;
        private OHttpCryptoConfiguration configuration;
        private OHttpServerKeys serverKeys;
        private OHttpCiphersuite ciphersuite;
        private byte[] encapsulatedKey;
        private byte[] forcedResponseNonce;

        public Builder setOHttpCryptoProvider(OHttpCryptoProvider provider) {
            this.provider = provider;
            return this;
        }

        public Builder setConfiguration(OHttpCryptoConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder setServerKeys(OHttpServerKeys value) {
            this.serverKeys = value;
            return this;
        }

        public Builder setCiphersuite(OHttpCiphersuite value) {
            this.ciphersuite = value;
            return this;
        }

        public Builder setEncapsulatedKey(byte[] value) {
            this.encapsulatedKey = value;
            return this;
        }

        public Builder setForcedResponseNonce(byte[] value) {
            this.forcedResponseNonce = value;
            return this;
        }

        public OHttpCryptoReceiver build() {
            return new OHttpCryptoReceiver(this);
        }

        private Builder() {
        }
    }
}

