/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.ohttp;

import io.netty.buffer.ByteBuf;
import io.netty.incubator.codec.hpke.AsymmetricCipherKeyPair;
import io.netty.incubator.codec.hpke.AsymmetricKeyParameter;
import io.netty.incubator.codec.hpke.CryptoOperations;
import io.netty.incubator.codec.hpke.HPKE;
import io.netty.incubator.codec.hpke.HPKEContext;
import io.netty.incubator.codec.hpke.HPKEContextWithEncapsulation;
import io.netty.incubator.codec.hpke.HybridPublicKeyEncryption;
import io.netty.incubator.codec.ohttp.OHttpCiphersuite;
import io.netty.incubator.codec.ohttp.OHttpCrypto;
import io.netty.incubator.codec.ohttp.OHttpCryptoConfiguration;
import java.util.Objects;

public final class OHttpCryptoSender
extends OHttpCrypto {
    private final OHttpCryptoConfiguration configuration;
    private final OHttpCiphersuite ciphersuite;
    private final HybridPublicKeyEncryption encryption;
    private final HPKEContextWithEncapsulation context;
    private CryptoOperations aead;

    public static Builder newBuilder() {
        return new Builder();
    }

    private OHttpCryptoSender(Builder builder) {
        this.configuration = Objects.requireNonNull(builder.configuration, "configuration");
        this.ciphersuite = Objects.requireNonNull(builder.ciphersuite, "ciphersuite");
        Objects.requireNonNull(builder.receiverPublicKeyBytes, "receiverPublicKeyBytes");
        this.encryption = Objects.requireNonNull(builder.encryption, "encryption");
        HPKE hpke = this.ciphersuite.newHPKE(builder.encryption);
        AsymmetricKeyParameter pkR = hpke.deserializePublicKey(builder.receiverPublicKeyBytes);
        this.context = builder.forcedEphemeralKeyPair == null ? hpke.setupBaseS(pkR, this.ciphersuite.createInfo(this.configuration), null) : hpke.setupBaseS(pkR, this.ciphersuite.createInfo(this.configuration), builder.forcedEphemeralKeyPair);
    }

    public OHttpCiphersuite ciphersuite() {
        return this.ciphersuite;
    }

    public void writeHeader(ByteBuf out) {
        this.ciphersuite.encode(out);
        out.writeBytes(this.context.encapsulation());
    }

    public boolean readResponseNonce(ByteBuf in) {
        if (in.readableBytes() < this.ciphersuite().responseNonceLength()) {
            return false;
        }
        byte[] responseNonce = new byte[this.ciphersuite().responseNonceLength()];
        in.readBytes(responseNonce);
        this.aead = this.ciphersuite.createResponseAead(this.encryption, (HPKEContext)this.context, this.context.encapsulation(), responseNonce, this.configuration);
        return true;
    }

    @Override
    protected CryptoOperations encryptCrypto() {
        return this.context;
    }

    @Override
    protected CryptoOperations decryptCrypto() {
        return this.aead;
    }

    @Override
    protected OHttpCryptoConfiguration configuration() {
        return this.configuration;
    }

    public static final class Builder {
        private HybridPublicKeyEncryption encryption;
        private OHttpCryptoConfiguration configuration;
        private OHttpCiphersuite ciphersuite;
        private byte[] receiverPublicKeyBytes;
        private AsymmetricCipherKeyPair forcedEphemeralKeyPair;

        public Builder setHybridPublicKeyEncryption(HybridPublicKeyEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public Builder setConfiguration(OHttpCryptoConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder setCiphersuite(OHttpCiphersuite value) {
            this.ciphersuite = value;
            return this;
        }

        public Builder setReceiverPublicKeyBytes(byte[] value) {
            this.receiverPublicKeyBytes = value;
            return this;
        }

        Builder setForcedEphemeralKeyPair(AsymmetricCipherKeyPair value) {
            this.forcedEphemeralKeyPair = value;
            return this;
        }

        public OHttpCryptoSender build() {
            return new OHttpCryptoSender(this);
        }

        private Builder() {
        }
    }
}

