/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.ohttp;

import io.netty.incubator.codec.hpke.AEAD;
import io.netty.incubator.codec.hpke.AsymmetricCipherKeyPair;
import io.netty.incubator.codec.hpke.CryptoException;
import io.netty.incubator.codec.hpke.KDF;
import io.netty.incubator.codec.hpke.KEM;
import io.netty.incubator.codec.ohttp.OHttpCiphersuite;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public abstract class OHttpKey {
    private final byte id;
    private final KEM kem;
    private final List<Cipher> ciphers;

    OHttpKey(byte id, KEM kem, List<Cipher> ciphers) {
        this.id = id;
        this.kem = Objects.requireNonNull(kem);
        this.ciphers = Collections.unmodifiableList(Objects.requireNonNull(ciphers, "ciphers"));
    }

    public byte id() {
        return this.id;
    }

    public KEM kem() {
        return this.kem;
    }

    public List<Cipher> ciphers() {
        return this.ciphers;
    }

    public List<OHttpCiphersuite> ciphersuites() {
        return this.ciphers.stream().map(c -> new OHttpCiphersuite(this.id, this.kem, c.kdf(), c.aead())).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OHttpKey oHttpKey = (OHttpKey)o;
        return this.id == oHttpKey.id && this.kem == oHttpKey.kem && Objects.equals(this.ciphers, oHttpKey.ciphers);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.kem, this.ciphers);
    }

    public static PublicKey newPublicKey(byte id, KEM kem, List<Cipher> ciphers, byte[] pkEncoded) throws CryptoException {
        return new PublicKey(id, kem, ciphers, pkEncoded);
    }

    public static Cipher newCipher(KDF kdf, AEAD aead) {
        return new Cipher(kdf, aead);
    }

    public static PrivateKey newPrivateKey(byte id, KEM kem, List<Cipher> ciphers, AsymmetricCipherKeyPair keyPair) throws CryptoException {
        return new PrivateKey(id, kem, ciphers, keyPair);
    }

    public static final class PrivateKey
    extends OHttpKey {
        private final AsymmetricCipherKeyPair keyPair;

        public AsymmetricCipherKeyPair keyPair() {
            return this.keyPair;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PrivateKey that = (PrivateKey)o;
            return Objects.equals(this.keyPair, that.keyPair);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.keyPair);
        }

        private PrivateKey(byte id, KEM kem, List<Cipher> ciphers, AsymmetricCipherKeyPair keyPair) throws CryptoException {
            super(id, kem, ciphers);
            Objects.requireNonNull(keyPair, "keyPair");
            byte[] encoded = keyPair.privateParameters().encoded();
            if (encoded != null && encoded.length != kem.npk()) {
                throw new CryptoException("Invalid public key, pkEncoded.length does not match Npk from KEM");
            }
            this.keyPair = keyPair;
        }
    }

    public static final class PublicKey
    extends OHttpKey {
        private final byte[] pkEncoded;

        public byte[] pkEncoded() {
            return (byte[])this.pkEncoded.clone();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PublicKey publicKey = (PublicKey)o;
            return Arrays.equals(this.pkEncoded, publicKey.pkEncoded);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), Arrays.hashCode(this.pkEncoded));
        }

        private PublicKey(byte id, KEM kem, List<Cipher> ciphers, byte[] pkEncoded) throws CryptoException {
            super(id, kem, ciphers);
            this.pkEncoded = (byte[])Objects.requireNonNull(pkEncoded, "pkEncoded").clone();
            if (pkEncoded.length != kem.npk()) {
                throw new CryptoException("Invalid public key, pkEncoded.length does not match Npk from KEM");
            }
        }
    }

    public static final class Cipher {
        private final KDF kdf;
        private final AEAD aead;

        public KDF kdf() {
            return this.kdf;
        }

        public AEAD aead() {
            return this.aead;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Cipher cipher = (Cipher)o;
            return this.kdf == cipher.kdf && this.aead == cipher.aead;
        }

        public int hashCode() {
            return Objects.hash(this.kdf, this.aead);
        }

        private Cipher(KDF kdf, AEAD aead) {
            this.kdf = Objects.requireNonNull(kdf, "kdf");
            this.aead = Objects.requireNonNull(aead, "aead");
        }
    }
}

