/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.ohttp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.incubator.codec.hpke.AEAD;
import io.netty.incubator.codec.hpke.CryptoException;
import io.netty.incubator.codec.hpke.KDF;
import io.netty.incubator.codec.hpke.KEM;
import io.netty.incubator.codec.ohttp.OHttpCiphersuite;
import io.netty.incubator.codec.ohttp.OHttpKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class OHttpServerPublicKeys
implements Iterable<Map.Entry<Byte, OHttpKey.PublicKey>> {
    private final Map<Byte, OHttpKey.PublicKey> keys;

    public OHttpServerPublicKeys(Map<Byte, OHttpKey.PublicKey> keys) {
        this.keys = Collections.unmodifiableMap(Objects.requireNonNull(keys, "keys"));
    }

    public Collection<OHttpKey.PublicKey> keys() {
        return this.keys.values();
    }

    public OHttpKey.PublicKey key(byte keyId) {
        return this.keys.get(keyId);
    }

    @Override
    public Iterator<Map.Entry<Byte, OHttpKey.PublicKey>> iterator() {
        return this.keys.entrySet().iterator();
    }

    public String toString() {
        return this.keys.values().stream().map(k -> "{ciphers=" + k.ciphersuites().stream().map(OHttpCiphersuite::toString).collect(Collectors.joining(", ", "[", "]")) + ", publicKey=" + ByteBufUtil.hexDump((byte[])k.pkEncoded()) + "}").collect(Collectors.joining(", ", "[", "]"));
    }

    @Deprecated
    public static OHttpServerPublicKeys decode(ByteBuf input) throws CryptoException {
        return OHttpServerPublicKeys.decode0(input, false);
    }

    public static OHttpServerPublicKeys decodeKeyConfigurationMediaType(ByteBuf input) throws CryptoException {
        return OHttpServerPublicKeys.decode0(input, true);
    }

    private static OHttpServerPublicKeys decode0(ByteBuf input, boolean rfc9458Mode) throws CryptoException {
        HashMap<Byte, OHttpKey.PublicKey> keys = new HashMap<Byte, OHttpKey.PublicKey>();
        while (input.isReadable()) {
            int length = -1;
            if (rfc9458Mode) {
                length = input.readShort();
            }
            int readerIndex = input.readerIndex();
            byte keyId = input.readByte();
            KEM kem = KEM.forId((short)input.readShort());
            byte[] publicKeyBytes = new byte[kem.npk()];
            input.readBytes(publicKeyBytes);
            short len = input.readShort();
            ByteBuf ecInput = input.readSlice((int)len);
            ArrayList<OHttpKey.Cipher> ciphers = new ArrayList<OHttpKey.Cipher>();
            while (ecInput.isReadable()) {
                KDF kdf = KDF.forId((short)ecInput.readShort());
                AEAD aead = AEAD.forId((short)ecInput.readShort());
                ciphers.add(OHttpKey.newCipher(kdf, aead));
            }
            if (rfc9458Mode && input.readerIndex() - readerIndex != length) {
                throw new CryptoException("Unable to decode key configuration media type");
            }
            OHttpKey.PublicKey publicKey = OHttpKey.newPublicKey(keyId, kem, ciphers, publicKeyBytes);
            keys.put(keyId, publicKey);
        }
        return new OHttpServerPublicKeys(keys);
    }
}

