/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.ohttp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.incubator.codec.bhttp.BinaryHttpParser;
import io.netty.incubator.codec.bhttp.BinaryHttpSerializer;
import io.netty.incubator.codec.hpke.CryptoException;
import io.netty.incubator.codec.ohttp.OHttpChunkFramer;
import io.netty.incubator.codec.ohttp.OHttpVersion;
import java.util.List;

abstract class OHttpRequestResponseContext {
    private final OHttpVersion version;
    private final ContentEncoder contentEncoder = new ContentEncoder();
    private ContentDecoder decoder = new ContentDecoder();

    OHttpRequestResponseContext(OHttpVersion version) {
        this.version = version;
    }

    final OHttpVersion version() {
        return this.version;
    }

    final void serialize(ByteBufAllocator alloc, HttpObject msg, ByteBuf out) throws CryptoException {
        this.version.serialize(alloc, msg, this.contentEncoder, out);
    }

    protected abstract void encryptChunk(ByteBufAllocator var1, ByteBuf var2, int var3, boolean var4, ByteBuf var5) throws CryptoException;

    protected abstract void encodePrefix(ByteBufAllocator var1, ByteBuf var2) throws CryptoException;

    final void parse(ByteBufAllocator alloc, ByteBuf in, boolean completeBodyReceived, List<Object> out) throws CryptoException {
        if (this.decoder == null) {
            throw new IllegalStateException("Already destroyed");
        }
        try {
            this.version.parse(alloc, in, completeBodyReceived, this.decoder, out);
        }
        catch (RuntimeException e) {
            if (this.decoder.isPrefixNeeded()) {
                throw new CryptoException("Unable to parse prefix", (Throwable)e);
            }
            throw e;
        }
        if (completeBodyReceived && in.isReadable()) {
            throw new CorruptedFrameException("OHTTP stream has extra bytes");
        }
    }

    protected abstract boolean decodePrefix(ByteBufAllocator var1, ByteBuf var2) throws CryptoException;

    protected abstract void decryptChunk(ByteBufAllocator var1, ByteBuf var2, int var3, boolean var4, ByteBuf var5) throws CryptoException;

    final void destroy() {
        if (this.decoder != null) {
            this.decoder.destroy();
            this.decoder = null;
        }
        this.destroyCrypto();
    }

    abstract void destroyCrypto();

    private final class ContentDecoder
    implements OHttpChunkFramer.Decoder {
        private final BinaryHttpParser binaryHttpParser = new BinaryHttpParser(8192);
        private ByteBuf binaryHttpCumulation = Unpooled.EMPTY_BUFFER;
        private boolean decodedPrefix;

        private ContentDecoder() {
        }

        @Override
        public boolean isPrefixNeeded() {
            return !this.decodedPrefix;
        }

        @Override
        public boolean decodePrefix(ByteBufAllocator alloc, ByteBuf in) throws CryptoException {
            if (this.decodedPrefix) {
                throw new IllegalStateException("Prefix already decoded");
            }
            if (OHttpRequestResponseContext.this.decodePrefix(alloc, in)) {
                this.decodedPrefix = true;
                return true;
            }
            return false;
        }

        @Override
        public void decodeChunk(ByteBufAllocator alloc, ByteBuf chunk, int chunkLength, boolean completeBodyReceived, List<Object> out) throws CryptoException {
            ByteBuf decryptedChunk = alloc.buffer();
            OHttpRequestResponseContext.this.decryptChunk(alloc, chunk, chunkLength, completeBodyReceived, decryptedChunk);
            this.binaryHttpCumulation = ByteToMessageDecoder.MERGE_CUMULATOR.cumulate(alloc, this.binaryHttpCumulation, decryptedChunk);
            HttpObject msg;
            while ((msg = this.binaryHttpParser.parse(this.binaryHttpCumulation, completeBodyReceived)) != null) {
                out.add(msg);
            }
            return;
        }

        void destroy() {
            this.binaryHttpCumulation.release();
            this.binaryHttpCumulation = Unpooled.EMPTY_BUFFER;
        }
    }

    private final class ContentEncoder
    implements OHttpChunkFramer.Encoder<HttpObject> {
        private final BinaryHttpSerializer binaryHttpSerializer = new BinaryHttpSerializer();
        private boolean encodedPrefix;

        private ContentEncoder() {
        }

        @Override
        public boolean isPrefixNeeded() {
            return !this.encodedPrefix;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void encodeChunk(ByteBufAllocator alloc, HttpObject msg, ByteBuf out) throws CryptoException {
            ByteBuf binaryHttpBytes = alloc.buffer();
            try {
                boolean isFinal = msg instanceof LastHttpContent;
                this.binaryHttpSerializer.serialize(msg, binaryHttpBytes);
                OHttpRequestResponseContext.this.encryptChunk(alloc, binaryHttpBytes, binaryHttpBytes.readableBytes(), isFinal, out);
            }
            finally {
                binaryHttpBytes.release();
            }
        }

        @Override
        public void encodePrefix(ByteBufAllocator alloc, ByteBuf out) throws CryptoException {
            if (this.encodedPrefix) {
                throw new IllegalStateException("Prefix already encoded");
            }
            OHttpRequestResponseContext.this.encodePrefix(alloc, out);
            this.encodedPrefix = true;
        }
    }
}

