/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.ohttp;

import io.netty.incubator.codec.hpke.AsymmetricCipherKeyPair;
import io.netty.incubator.codec.hpke.CryptoException;
import io.netty.incubator.codec.hpke.HybridPublicKeyEncryption;
import io.netty.incubator.codec.ohttp.OHttpCiphersuite;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public abstract class OHttpKey {
    private final byte id;
    private final HybridPublicKeyEncryption.KEM kem;
    private final List<Cipher> ciphers;

    OHttpKey(byte id, HybridPublicKeyEncryption.KEM kem, List<Cipher> ciphers) {
        this.id = id;
        this.kem = Objects.requireNonNull(kem);
        this.ciphers = Collections.unmodifiableList(Objects.requireNonNull(ciphers, "ciphers"));
    }

    public byte id() {
        return this.id;
    }

    public HybridPublicKeyEncryption.KEM kem() {
        return this.kem;
    }

    public List<Cipher> ciphers() {
        return this.ciphers;
    }

    public List<OHttpCiphersuite> ciphersuites() {
        return this.ciphers.stream().map(c -> new OHttpCiphersuite(this.id, this.kem, c.kdf(), c.aead())).collect(Collectors.toList());
    }

    public static PublicKey newPublicKey(byte id, HybridPublicKeyEncryption.KEM kem, List<Cipher> ciphers, byte[] pkEncoded) throws CryptoException {
        return new PublicKey(id, kem, ciphers, pkEncoded);
    }

    public static Cipher newCipher(HybridPublicKeyEncryption.KDF kdf, HybridPublicKeyEncryption.AEAD aead) {
        return new Cipher(kdf, aead);
    }

    public static PrivateKey newPrivateKey(byte id, HybridPublicKeyEncryption.KEM kem, List<Cipher> ciphers, AsymmetricCipherKeyPair keyPair) throws CryptoException {
        return new PrivateKey(id, kem, ciphers, keyPair);
    }

    public static final class PrivateKey
    extends OHttpKey {
        private final AsymmetricCipherKeyPair keyPair;

        public AsymmetricCipherKeyPair keyPair() {
            return this.keyPair;
        }

        private PrivateKey(byte id, HybridPublicKeyEncryption.KEM kem, List<Cipher> ciphers, AsymmetricCipherKeyPair keyPair) throws CryptoException {
            super(id, kem, ciphers);
            Objects.requireNonNull(keyPair, "keyPair");
            byte[] encoded = keyPair.privateParameters().encoded();
            if (encoded != null && encoded.length != kem.npk()) {
                throw new CryptoException("Invalid public key, pkEncoded.length does not match Npk from KEM");
            }
            this.keyPair = keyPair;
        }
    }

    public static final class PublicKey
    extends OHttpKey {
        private final byte[] pkEncoded;

        public byte[] pkEncoded() {
            return (byte[])this.pkEncoded.clone();
        }

        private PublicKey(byte id, HybridPublicKeyEncryption.KEM kem, List<Cipher> ciphers, byte[] pkEncoded) throws CryptoException {
            super(id, kem, ciphers);
            this.pkEncoded = (byte[])Objects.requireNonNull(pkEncoded, "pkEncoded").clone();
            if (pkEncoded.length != kem.npk()) {
                throw new CryptoException("Invalid public key, pkEncoded.length does not match Npk from KEM");
            }
        }
    }

    public static final class Cipher {
        private final HybridPublicKeyEncryption.KDF kdf;
        private final HybridPublicKeyEncryption.AEAD aead;

        public HybridPublicKeyEncryption.KDF kdf() {
            return this.kdf;
        }

        public HybridPublicKeyEncryption.AEAD aead() {
            return this.aead;
        }

        private Cipher(HybridPublicKeyEncryption.KDF kdf, HybridPublicKeyEncryption.AEAD aead) {
            this.kdf = Objects.requireNonNull(kdf, "kdf");
            this.aead = Objects.requireNonNull(aead, "aead");
        }
    }
}

