/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.bhttp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.incubator.codec.bhttp.BinaryHttpHeaders;
import io.netty.incubator.codec.bhttp.FullBinaryHttpResponse;

public final class DefaultFullBinaryHttpResponse
extends DefaultFullHttpResponse
implements FullBinaryHttpResponse {
    public DefaultFullBinaryHttpResponse(HttpVersion version, HttpResponseStatus status) {
        this(version, status, Unpooled.EMPTY_BUFFER);
    }

    public DefaultFullBinaryHttpResponse(HttpVersion version, HttpResponseStatus status, ByteBuf content) {
        this(version, status, content, true);
    }

    public DefaultFullBinaryHttpResponse(HttpVersion version, HttpResponseStatus status, boolean validateHeaders) {
        this(version, status, Unpooled.EMPTY_BUFFER, validateHeaders);
    }

    public DefaultFullBinaryHttpResponse(HttpVersion version, HttpResponseStatus status, ByteBuf content, boolean validateHeaders) {
        this(version, status, content, (HttpHeaders)BinaryHttpHeaders.newHeaders(validateHeaders), (HttpHeaders)BinaryHttpHeaders.newTrailers(validateHeaders));
    }

    private DefaultFullBinaryHttpResponse(HttpVersion version, HttpResponseStatus status, ByteBuf content, HttpHeaders headers, HttpHeaders trailingHeaders) {
        super(version, status, content, headers, trailingHeaders);
    }

    @Override
    public FullBinaryHttpResponse retain() {
        super.retain();
        return this;
    }

    @Override
    public FullBinaryHttpResponse retain(int increment) {
        super.retain(increment);
        return this;
    }

    @Override
    public FullBinaryHttpResponse touch() {
        super.touch();
        return this;
    }

    @Override
    public FullBinaryHttpResponse touch(Object hint) {
        super.touch(hint);
        return this;
    }

    @Override
    public FullBinaryHttpResponse setProtocolVersion(HttpVersion version) {
        super.setProtocolVersion(version);
        return this;
    }

    @Override
    public FullBinaryHttpResponse setStatus(HttpResponseStatus status) {
        super.setStatus(status);
        return this;
    }

    @Override
    public FullBinaryHttpResponse copy() {
        return this.replace(this.content().copy());
    }

    @Override
    public FullBinaryHttpResponse duplicate() {
        return this.replace(this.content().duplicate());
    }

    @Override
    public FullBinaryHttpResponse retainedDuplicate() {
        return this.replace(this.content().retainedDuplicate());
    }

    @Override
    public FullBinaryHttpResponse replace(ByteBuf content) {
        DefaultFullBinaryHttpResponse response = new DefaultFullBinaryHttpResponse(this.protocolVersion(), this.status(), content, this.headers().copy(), this.trailingHeaders().copy());
        response.setDecoderResult(this.decoderResult());
        return response;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return super.equals(o);
    }
}

