/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.example.socksproxy;

import io.netty.contrib.handler.codec.example.socksproxy.DirectClientHandler;
import io.netty.contrib.handler.codec.example.socksproxy.RelayHandler;
import io.netty.contrib.handler.codec.example.socksproxy.SocksServerUtils;
import io.netty.contrib.handler.codec.socksx.SocksMessage;
import io.netty.contrib.handler.codec.socksx.v4.DefaultSocks4CommandResponse;
import io.netty.contrib.handler.codec.socksx.v4.Socks4CommandRequest;
import io.netty.contrib.handler.codec.socksx.v4.Socks4CommandStatus;
import io.netty.contrib.handler.codec.socksx.v5.DefaultSocks5CommandResponse;
import io.netty.contrib.handler.codec.socksx.v5.Socks5CommandRequest;
import io.netty.contrib.handler.codec.socksx.v5.Socks5CommandStatus;
import io.netty5.bootstrap.Bootstrap;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.ChannelOption;
import io.netty5.channel.EventLoopGroup;
import io.netty5.channel.SimpleChannelInboundHandler;
import io.netty5.channel.socket.nio.NioSocketChannel;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.Promise;

public final class SocksServerConnectHandler
extends SimpleChannelInboundHandler<SocksMessage> {
    private final Bootstrap b = new Bootstrap();

    public void messageReceived(ChannelHandlerContext ctx, SocksMessage message) throws Exception {
        if (message instanceof Socks4CommandRequest) {
            Socks4CommandRequest request = (Socks4CommandRequest)message;
            Promise promise = ctx.executor().newPromise();
            promise.asFuture().addListener(future -> {
                Channel outboundChannel = (Channel)future.getNow();
                if (future.isSuccess()) {
                    Future responseFuture = ctx.channel().writeAndFlush((Object)new DefaultSocks4CommandResponse(Socks4CommandStatus.SUCCESS));
                    responseFuture.addListener(fut -> {
                        ctx.pipeline().remove((ChannelHandler)this);
                        outboundChannel.pipeline().addLast(new ChannelHandler[]{new RelayHandler(ctx.channel())});
                        ctx.pipeline().addLast(new ChannelHandler[]{new RelayHandler(outboundChannel)});
                    });
                } else {
                    ctx.channel().writeAndFlush((Object)new DefaultSocks4CommandResponse(Socks4CommandStatus.REJECTED_OR_FAILED));
                    SocksServerUtils.closeOnFlush(ctx.channel());
                }
            });
            Channel inboundChannel = ctx.channel();
            ((Bootstrap)((Bootstrap)((Bootstrap)this.b.group((EventLoopGroup)inboundChannel.executor())).channel(NioSocketChannel.class).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)10000)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).handler((ChannelHandler)new DirectClientHandler((Promise<Channel>)promise));
            this.b.connect(request.dstAddr(), request.dstPort()).addListener(future -> {
                if (!future.isSuccess()) {
                    ctx.channel().writeAndFlush((Object)new DefaultSocks4CommandResponse(Socks4CommandStatus.REJECTED_OR_FAILED));
                    SocksServerUtils.closeOnFlush(ctx.channel());
                }
            });
        } else if (message instanceof Socks5CommandRequest) {
            Socks5CommandRequest request = (Socks5CommandRequest)message;
            Promise promise = ctx.executor().newPromise();
            promise.asFuture().addListener(future -> {
                Channel outboundChannel = (Channel)future.getNow();
                if (future.isSuccess()) {
                    Future responseFuture = ctx.channel().writeAndFlush((Object)new DefaultSocks5CommandResponse(Socks5CommandStatus.SUCCESS, request.dstAddrType(), request.dstAddr(), request.dstPort()));
                    responseFuture.addListener(fut -> {
                        ctx.pipeline().remove((ChannelHandler)this);
                        outboundChannel.pipeline().addLast(new ChannelHandler[]{new RelayHandler(ctx.channel())});
                        ctx.pipeline().addLast(new ChannelHandler[]{new RelayHandler(outboundChannel)});
                    });
                } else {
                    ctx.channel().writeAndFlush((Object)new DefaultSocks5CommandResponse(Socks5CommandStatus.FAILURE, request.dstAddrType()));
                    SocksServerUtils.closeOnFlush(ctx.channel());
                }
            });
            Channel inboundChannel = ctx.channel();
            ((Bootstrap)((Bootstrap)((Bootstrap)this.b.group((EventLoopGroup)inboundChannel.executor())).channel(NioSocketChannel.class).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)10000)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).handler((ChannelHandler)new DirectClientHandler((Promise<Channel>)promise));
            this.b.connect(request.dstAddr(), request.dstPort()).addListener(future -> {
                if (!future.isSuccess()) {
                    ctx.channel().writeAndFlush((Object)new DefaultSocks5CommandResponse(Socks5CommandStatus.FAILURE, request.dstAddrType()));
                    SocksServerUtils.closeOnFlush(ctx.channel());
                }
            });
        } else {
            ctx.close();
        }
    }

    public void channelExceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        SocksServerUtils.closeOnFlush(ctx.channel());
    }

    public boolean isSharable() {
        return true;
    }
}

