/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.example.socksproxy;

import io.netty.contrib.handler.codec.example.socksproxy.SocksServerUtils;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.util.ReferenceCountUtil;

public final class RelayHandler
implements ChannelHandler {
    private final Channel relayChannel;

    public RelayHandler(Channel relayChannel) {
        this.relayChannel = relayChannel;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        ctx.writeAndFlush((Object)ctx.bufferAllocator().allocate(0));
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (this.relayChannel.isActive()) {
            this.relayChannel.writeAndFlush(msg);
        } else {
            ReferenceCountUtil.release((Object)msg);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        if (this.relayChannel.isActive()) {
            SocksServerUtils.closeOnFlush(this.relayChannel);
        }
    }

    public void channelExceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        ctx.close();
    }
}

