/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.proxy;

import io.netty.contrib.handler.proxy.ProxyConnectException;
import io.netty.contrib.handler.proxy.ProxyHandler;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.ChannelPipeline;
import io.netty5.channel.ChannelShutdownDirection;
import io.netty5.channel.ReadBufferAllocator;
import io.netty5.handler.codec.http.DefaultFullHttpRequest;
import io.netty5.handler.codec.http.HttpClientCodec;
import io.netty5.handler.codec.http.HttpHeaderNames;
import io.netty5.handler.codec.http.HttpMethod;
import io.netty5.handler.codec.http.HttpResponse;
import io.netty5.handler.codec.http.HttpResponseStatus;
import io.netty5.handler.codec.http.HttpUtil;
import io.netty5.handler.codec.http.HttpVersion;
import io.netty5.handler.codec.http.LastHttpContent;
import io.netty5.handler.codec.http.headers.HttpHeaders;
import io.netty5.util.AsciiString;
import io.netty5.util.concurrent.Future;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;

public final class HttpProxyHandler
extends ProxyHandler {
    private static final String PROTOCOL = "http";
    private static final String AUTH_BASIC = "basic";
    private static final byte[] BASIC_BYTES = "Basic ".getBytes(StandardCharsets.UTF_8);
    private final HttpClientCodecWrapper codecWrapper = new HttpClientCodecWrapper();
    private final String username;
    private final String password;
    private final CharSequence authorization;
    private final HttpHeaders outboundHeaders;
    private final boolean ignoreDefaultPortsInConnectHostHeader;
    private HttpResponseStatus status;
    private HttpHeaders inboundHeaders;

    public HttpProxyHandler(SocketAddress proxyAddress) {
        this(proxyAddress, null);
    }

    public HttpProxyHandler(SocketAddress proxyAddress, HttpHeaders headers) {
        this(proxyAddress, headers, false);
    }

    public HttpProxyHandler(SocketAddress proxyAddress, HttpHeaders headers, boolean ignoreDefaultPortsInConnectHostHeader) {
        super(proxyAddress);
        this.username = null;
        this.password = null;
        this.authorization = null;
        this.outboundHeaders = headers;
        this.ignoreDefaultPortsInConnectHostHeader = ignoreDefaultPortsInConnectHostHeader;
    }

    public HttpProxyHandler(SocketAddress proxyAddress, String username, String password) {
        this(proxyAddress, username, password, null);
    }

    public HttpProxyHandler(SocketAddress proxyAddress, String username, String password, HttpHeaders headers) {
        this(proxyAddress, username, password, headers, false);
    }

    public HttpProxyHandler(SocketAddress proxyAddress, String username, String password, HttpHeaders headers, boolean ignoreDefaultPortsInConnectHostHeader) {
        super(proxyAddress);
        Objects.requireNonNull(username, "username");
        Objects.requireNonNull(password, "password");
        this.username = username;
        this.password = password;
        byte[] authzBase64 = Base64.getEncoder().encode((username + ":" + password).getBytes(StandardCharsets.UTF_8));
        byte[] authzHeader = Arrays.copyOf(BASIC_BYTES, 6 + authzBase64.length);
        System.arraycopy(authzBase64, 0, authzHeader, 6, authzBase64.length);
        this.authorization = new AsciiString(authzHeader, false);
        this.outboundHeaders = headers;
        this.ignoreDefaultPortsInConnectHostHeader = ignoreDefaultPortsInConnectHostHeader;
    }

    @Override
    public String protocol() {
        return PROTOCOL;
    }

    @Override
    public String authScheme() {
        return this.authorization != null ? AUTH_BASIC : "none";
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    @Override
    protected void addCodec(ChannelHandlerContext ctx) throws Exception {
        ChannelPipeline p = ctx.pipeline();
        String name = ctx.name();
        p.addBefore(name, null, (ChannelHandler)this.codecWrapper);
    }

    @Override
    protected void removeEncoder(ChannelHandlerContext ctx) throws Exception {
        this.codecWrapper.codec.removeOutboundHandler();
    }

    @Override
    protected void removeDecoder(ChannelHandlerContext ctx) throws Exception {
        this.codecWrapper.codec.removeInboundHandler();
    }

    @Override
    protected Object newInitialMessage(ChannelHandlerContext ctx) throws Exception {
        InetSocketAddress raddr = (InetSocketAddress)this.destinationAddress();
        String hostString = HttpUtil.formatHostnameForHttp((InetSocketAddress)raddr);
        int port = raddr.getPort();
        String url = hostString + ":" + port;
        String hostHeader = this.ignoreDefaultPortsInConnectHostHeader && (port == 80 || port == 443) ? hostString : url;
        DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.CONNECT, url, ctx.bufferAllocator().allocate(0), false);
        req.headers().set((CharSequence)HttpHeaderNames.HOST, (CharSequence)hostHeader);
        if (this.authorization != null) {
            req.headers().set((CharSequence)HttpHeaderNames.PROXY_AUTHORIZATION, this.authorization);
        }
        if (this.outboundHeaders != null) {
            req.headers().add(this.outboundHeaders);
        }
        return req;
    }

    @Override
    protected boolean handleResponse(ChannelHandlerContext ctx, Object response) throws Exception {
        boolean finished;
        if (response instanceof HttpResponse) {
            if (this.status != null) {
                throw new HttpProxyConnectException(this.exceptionMessage("too many responses"), null);
            }
            HttpResponse res = (HttpResponse)response;
            this.status = res.status();
            this.inboundHeaders = res.headers();
        }
        if (finished = response instanceof LastHttpContent) {
            if (this.status == null) {
                throw new HttpProxyConnectException(this.exceptionMessage("missing response"), this.inboundHeaders);
            }
            if (this.status.code() != 200) {
                throw new HttpProxyConnectException(this.exceptionMessage("status: " + this.status), this.inboundHeaders);
            }
        }
        return finished;
    }

    private static final class HttpClientCodecWrapper
    implements ChannelHandler {
        final HttpClientCodec codec = new HttpClientCodec();

        private HttpClientCodecWrapper() {
        }

        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            this.codec.handlerAdded(ctx);
        }

        public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
            this.codec.handlerRemoved(ctx);
        }

        public void channelExceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            this.codec.channelExceptionCaught(ctx, cause);
        }

        public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
            this.codec.channelRegistered(ctx);
        }

        public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
            this.codec.channelUnregistered(ctx);
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.codec.channelActive(ctx);
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            this.codec.channelInactive(ctx);
        }

        public void channelShutdown(ChannelHandlerContext ctx, ChannelShutdownDirection direction) throws Exception {
            this.codec.channelShutdown(ctx, direction);
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            this.codec.channelRead(ctx, msg);
        }

        public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
            this.codec.channelReadComplete(ctx);
        }

        public void channelInboundEvent(ChannelHandlerContext ctx, Object evt) throws Exception {
            this.codec.channelInboundEvent(ctx, evt);
        }

        public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
            this.codec.channelWritabilityChanged(ctx);
        }

        public Future<Void> bind(ChannelHandlerContext ctx, SocketAddress localAddress) {
            return this.codec.bind(ctx, localAddress);
        }

        public Future<Void> connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress) {
            return this.codec.connect(ctx, remoteAddress, localAddress);
        }

        public Future<Void> disconnect(ChannelHandlerContext ctx) {
            return this.codec.disconnect(ctx);
        }

        public Future<Void> close(ChannelHandlerContext ctx) {
            return this.codec.close(ctx);
        }

        public Future<Void> shutdown(ChannelHandlerContext ctx, ChannelShutdownDirection direction) {
            return this.codec.shutdown(ctx, direction);
        }

        public Future<Void> register(ChannelHandlerContext ctx) {
            return this.codec.register(ctx);
        }

        public Future<Void> deregister(ChannelHandlerContext ctx) {
            return this.codec.deregister(ctx);
        }

        public void read(ChannelHandlerContext ctx, ReadBufferAllocator readBufferAllocator) {
            this.codec.read(ctx, readBufferAllocator);
        }

        public long pendingOutboundBytes(ChannelHandlerContext ctx) {
            return this.codec.pendingOutboundBytes(ctx);
        }

        public Future<Void> write(ChannelHandlerContext ctx, Object msg) {
            return this.codec.write(ctx, msg);
        }

        public void flush(ChannelHandlerContext ctx) {
            this.codec.flush(ctx);
        }

        public Future<Void> sendOutboundEvent(ChannelHandlerContext ctx, Object event) {
            return this.codec.sendOutboundEvent(ctx, event);
        }
    }

    public static final class HttpProxyConnectException
    extends ProxyConnectException {
        private static final long serialVersionUID = -8824334609292146066L;
        private final HttpHeaders headers;

        public HttpProxyConnectException(String message, HttpHeaders headers) {
            super(message);
            this.headers = headers;
        }

        public HttpHeaders headers() {
            return this.headers;
        }
    }
}

