/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.http.multipart;

import io.netty.contrib.handler.codec.http.multipart.AbstractHttpData;
import io.netty.contrib.handler.codec.http.multipart.AbstractMemoryHttpData;
import io.netty.contrib.handler.codec.http.multipart.Attribute;
import io.netty.contrib.handler.codec.http.multipart.InterfaceHttpData;
import io.netty5.buffer.Buffer;
import io.netty5.buffer.DefaultBufferAllocators;
import io.netty5.buffer.Owned;
import io.netty5.buffer.internal.InternalBufferUtils;
import io.netty5.channel.ChannelException;
import io.netty5.handler.codec.http.HttpConstants;
import io.netty5.util.Send;
import io.netty5.util.internal.ObjectUtil;
import java.io.IOException;
import java.nio.charset.Charset;

public class MemoryAttribute
extends AbstractMemoryHttpData
implements Attribute {
    public MemoryAttribute(String name) {
        this(name, HttpConstants.DEFAULT_CHARSET);
    }

    public MemoryAttribute(String name, long definedSize) {
        this(name, definedSize, HttpConstants.DEFAULT_CHARSET);
    }

    public MemoryAttribute(String name, Charset charset) {
        super(name, charset, 0L);
    }

    public MemoryAttribute(String name, long definedSize, Charset charset) {
        super(name, charset, definedSize);
    }

    public MemoryAttribute(String name, String value) throws IOException {
        this(name, value, HttpConstants.DEFAULT_CHARSET);
    }

    public MemoryAttribute(String name, String value, Charset charset) throws IOException {
        super(name, charset, 0L);
        this.setValue(value);
    }

    @Override
    public InterfaceHttpData.HttpDataType getHttpDataType() {
        return InterfaceHttpData.HttpDataType.Attribute;
    }

    @Override
    public String getValue() {
        return this.byteBuf.toString(this.getCharset());
    }

    @Override
    public void setValue(String value) throws IOException {
        this.checkAccessible();
        ObjectUtil.checkNotNullWithIAE((Object)value, (String)"value");
        byte[] bytes = value.getBytes(this.getCharset());
        this.checkSize(bytes.length);
        Buffer buffer = DefaultBufferAllocators.preferredAllocator().copyOf(bytes);
        if (this.definedSize > 0L) {
            this.definedSize = buffer.readableBytes();
        }
        this.setContent(buffer);
    }

    @Override
    public void addContent(Buffer buffer, boolean last) throws IOException {
        this.checkAccessible(buffer);
        int localsize = buffer.readableBytes();
        try {
            this.checkSize(this.size + (long)localsize);
        }
        catch (IOException e) {
            buffer.close();
            throw e;
        }
        if (this.definedSize > 0L && this.definedSize < this.size + (long)localsize) {
            this.definedSize = this.size + (long)localsize;
        }
        super.addContent(buffer, last);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Attribute)) {
            return false;
        }
        Attribute attribute = (Attribute)o;
        return this.getName().equalsIgnoreCase(attribute.getName());
    }

    @Override
    public int compareTo(InterfaceHttpData other) {
        if (!(other instanceof Attribute)) {
            throw new ClassCastException("Cannot compare " + this.getHttpDataType() + " with " + other.getHttpDataType());
        }
        return this.compareTo((Attribute)other);
    }

    @Override
    public int compareTo(Attribute o) {
        return this.getName().compareToIgnoreCase(o.getName());
    }

    public String toString() {
        return this.getName() + "=" + this.getValue();
    }

    @Override
    public Attribute copy() {
        return this.replace(this.byteBuf != null ? this.byteBuf.copy() : null);
    }

    @Override
    public Attribute replace(Buffer content) {
        this.checkAccessible(content);
        MemoryAttribute attr = new MemoryAttribute(this.getName());
        attr.setCharset(this.getCharset());
        if (content != null) {
            try {
                attr.setContent(content);
            }
            catch (IOException e) {
                throw new ChannelException((Throwable)e);
            }
        }
        attr.setCompleted(this.isCompleted());
        return attr;
    }

    protected Owned<AbstractHttpData> prepareSend() {
        Send send = this.byteBuf.send();
        return drop -> {
            Buffer received = (Buffer)send.receive();
            MemoryAttribute attr = new MemoryAttribute(this.getName());
            attr.setCharset(this.getCharset());
            attr.setContentInternal(received, received.readableBytes());
            attr.setMaxSize(this.getMaxSize());
            attr.setCompleted(this.isCompleted());
            attr.definedSize = this.definedSize;
            return attr;
        };
    }

    @Override
    protected RuntimeException createResourceClosedException() {
        return InternalBufferUtils.bufferIsClosed((Buffer)this.byteBuf);
    }
}

