/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.http.multipart;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.ByteCursor;
import io.netty5.util.ByteProcessor;

final class HttpPostBodyUtil {
    public static final int chunkSize = 8096;
    public static final String DEFAULT_BINARY_CONTENT_TYPE = "application/octet-stream";
    public static final String DEFAULT_TEXT_CONTENT_TYPE = "text/plain";
    private static final ByteProcessor.IndexOfProcessor LF_PROCESSOR = new ByteProcessor.IndexOfProcessor(10);

    private HttpPostBodyUtil() {
    }

    static int findNonWhitespace(String sb, int offset) {
        int result;
        for (result = offset; result < sb.length() && Character.isWhitespace(sb.charAt(result)); ++result) {
        }
        return result;
    }

    static int findEndOfString(String sb) {
        int result;
        for (result = sb.length(); result > 0 && Character.isWhitespace(sb.charAt(result - 1)); --result) {
        }
        return result;
    }

    static int findLineBreak(Buffer buffer, int index) {
        int toRead = buffer.readableBytes() - (index - buffer.readerOffset());
        ByteCursor cursor = buffer.openCursor(index, toRead);
        int posFirstChar = cursor.process((ByteProcessor)LF_PROCESSOR);
        if (posFirstChar == -1) {
            return -1;
        }
        if (posFirstChar > 0 && buffer.getByte(index + posFirstChar - 1) == 13) {
            --posFirstChar;
        }
        return posFirstChar;
    }

    static int findLastLineBreak(Buffer buffer, int index) {
        int next;
        int candidate = HttpPostBodyUtil.findLineBreak(buffer, index);
        int findCRLF = 0;
        if (candidate >= 0) {
            findCRLF = buffer.getByte(index + candidate) == 13 ? 2 : 1;
            candidate += findCRLF;
        }
        while (candidate > 0 && (next = HttpPostBodyUtil.findLineBreak(buffer, index + candidate)) >= 0) {
            findCRLF = buffer.getByte(index + (candidate += next)) == 13 ? 2 : 1;
            candidate += findCRLF;
        }
        return candidate - findCRLF;
    }

    static int findDelimiter(Buffer buffer, int index, byte[] delimiter, boolean precededByLineBreak) {
        int delimiterLength = delimiter.length;
        int readerIndex = buffer.readerOffset();
        int writerIndex = buffer.writerOffset();
        int toRead = writerIndex - index;
        int newOffset = index;
        boolean delimiterNotFound = true;
        while (delimiterNotFound && delimiterLength <= toRead) {
            ByteCursor cursor = buffer.openCursor(newOffset, toRead);
            int posDelimiter = cursor.process(value -> value != delimiter[0]);
            if (posDelimiter < 0) {
                return -1;
            }
            newOffset += posDelimiter;
            if ((toRead -= posDelimiter) >= delimiterLength) {
                delimiterNotFound = false;
                for (int i = 0; i < delimiterLength; ++i) {
                    if (buffer.getByte(newOffset + i) == delimiter[i]) continue;
                    ++newOffset;
                    --toRead;
                    delimiterNotFound = true;
                    break;
                }
            }
            if (delimiterNotFound) continue;
            if (precededByLineBreak && newOffset > readerIndex) {
                if (buffer.getByte(newOffset - 1) == 10) {
                    if (--newOffset > readerIndex && buffer.getByte(newOffset - 1) == 13) {
                        --newOffset;
                    }
                } else {
                    ++newOffset;
                    --toRead;
                    delimiterNotFound = true;
                    continue;
                }
            }
            return newOffset - readerIndex;
        }
        return -1;
    }

    public static enum TransferEncodingMechanism {
        BIT7("7bit"),
        BIT8("8bit"),
        BINARY("binary");

        private final String value;

        private TransferEncodingMechanism(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }
    }
}

