/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.crypto;

import io.neow3j.constants.NeoConstants;
import io.neow3j.contract.ScriptBuilder;
import io.neow3j.contract.ScriptHash;
import io.neow3j.crypto.Base58;
import io.neow3j.crypto.ECDSASignature;
import io.neow3j.crypto.Hash;
import io.neow3j.crypto.SecureRandomUtils;
import io.neow3j.crypto.SecurityProviderChecker;
import io.neow3j.crypto.Sign;
import io.neow3j.io.BinaryReader;
import io.neow3j.io.BinaryWriter;
import io.neow3j.io.NeoSerializable;
import io.neow3j.io.exceptions.DeserializationException;
import io.neow3j.utils.ArrayUtils;
import io.neow3j.utils.Numeric;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECPoint;
import java.util.Arrays;
import java.util.Objects;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.signers.DSAKCalculator;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.HMacDSAKCalculator;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.util.BigIntegers;

public class ECKeyPair {
    private final ECPrivateKey privateKey;
    private final ECPublicKey publicKey;

    public ECKeyPair(ECPrivateKey privateKey, ECPublicKey publicKey) {
        if (privateKey == null) {
            throw new IllegalArgumentException("A ECKeyPair cannot be created without a private key.");
        }
        this.privateKey = privateKey;
        this.publicKey = publicKey;
    }

    public ECPrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public ECPublicKey getPublicKey() {
        return this.publicKey;
    }

    public String getAddress() {
        byte[] script = ScriptBuilder.buildVerificationScript((byte[])this.publicKey.getEncoded(true));
        return ScriptHash.fromScript((byte[])script).toAddress();
    }

    public BigInteger[] sign(byte[] transactionHash) {
        ECDSASigner signer = new ECDSASigner((DSAKCalculator)new HMacDSAKCalculator((Digest)new SHA256Digest()));
        ECPrivateKeyParameters privKey = new ECPrivateKeyParameters(this.privateKey.getInt(), NeoConstants.curve());
        signer.init(true, (CipherParameters)privKey);
        return signer.generateSignature(transactionHash);
    }

    public ECDSASignature signAndGetECDSASignature(byte[] transactionHash) {
        BigInteger[] components = this.sign(transactionHash);
        return new ECDSASignature(components[0], components[1]);
    }

    public byte[] signAndGetArrayBytes(byte[] transactionHash) {
        BigInteger[] components = this.sign(transactionHash);
        byte[] signature = new byte[64];
        System.arraycopy(BigIntegers.asUnsignedByteArray((int)32, (BigInteger)components[0]), 0, signature, 0, 32);
        System.arraycopy(BigIntegers.asUnsignedByteArray((int)32, (BigInteger)components[1]), 0, signature, 32, 32);
        return signature;
    }

    public static ECKeyPair create(KeyPair keyPair) {
        BCECPrivateKey privateKey = (BCECPrivateKey)keyPair.getPrivate();
        BCECPublicKey publicKey = (BCECPublicKey)keyPair.getPublic();
        return new ECKeyPair(new ECPrivateKey(privateKey.getD()), new ECPublicKey(publicKey.getQ()));
    }

    public static ECKeyPair create(ECPrivateKey privateKey) {
        return new ECKeyPair(privateKey, Sign.publicKeyFromPrivate(privateKey));
    }

    public static ECKeyPair create(BigInteger privateKey) {
        return ECKeyPair.create(new ECPrivateKey(privateKey));
    }

    public static ECKeyPair create(byte[] privateKey) {
        return ECKeyPair.create(new ECPrivateKey(privateKey));
    }

    public static ECKeyPair createEcKeyPair() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        KeyPair keyPair = ECKeyPair.createSecp256r1KeyPair();
        return ECKeyPair.create(keyPair);
    }

    private static KeyPair createSecp256r1KeyPair() throws NoSuchProviderException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ECDSA", "BC");
        ECGenParameterSpec ecGenParameterSpec = new ECGenParameterSpec("secp256r1");
        keyPairGenerator.initialize(ecGenParameterSpec, SecureRandomUtils.secureRandom());
        return keyPairGenerator.generateKeyPair();
    }

    public String exportAsWIF() {
        byte[] data = ArrayUtils.concatenate((byte[][])new byte[][]{{-128}, Numeric.toBytesPadded((BigInteger)this.getPrivateKey().getInt(), (int)32), {1}});
        byte[] checksum = Hash.hash256((byte[])data, (int)0, (int)data.length);
        byte[] first4Bytes = Arrays.copyOfRange(checksum, 0, 4);
        data = ArrayUtils.concatenate((byte[])data, (byte[])first4Bytes);
        String wif = Base58.encode((byte[])data);
        Arrays.fill(data, (byte)0);
        return wif;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ECKeyPair that = (ECKeyPair)o;
        return Objects.equals(this.privateKey, that.privateKey) && Objects.equals((Object)this.publicKey, (Object)that.publicKey);
    }

    public int hashCode() {
        int result = this.privateKey != null ? this.privateKey.hashCode() : 0;
        result = 31 * result + (this.publicKey != null ? this.publicKey.hashCode() : 0);
        return result;
    }

    static {
        SecurityProviderChecker.addBouncyCastle();
    }

    public static class ECPublicKey
    extends NeoSerializable {
        private org.bouncycastle.math.ec.ECPoint ecPoint;

        public ECPublicKey() {
        }

        public ECPublicKey(String publicKey) {
            this(Numeric.hexStringToByteArray((String)publicKey));
        }

        public ECPublicKey(org.bouncycastle.math.ec.ECPoint ecPoint) {
            if (!ecPoint.getCurve().equals(NeoConstants.curveParams().getCurve())) {
                throw new IllegalArgumentException("Given EC point is not of the required curve.");
            }
            this.ecPoint = ecPoint;
        }

        public ECPublicKey(byte[] publicKey) {
            if (publicKey.length != 33) {
                throw new IllegalArgumentException("Public key argument must be 33 long but was " + publicKey.length + " bytes");
            }
            this.ecPoint = this.decodePoint(publicKey);
        }

        public ECPublicKey(BigInteger publicKey) {
            this(Numeric.toBytesPadded((BigInteger)publicKey, (int)33));
        }

        public byte[] getEncoded(boolean compressed) {
            return this.ecPoint.getEncoded(compressed);
        }

        public ECPoint getECPoint() {
            org.bouncycastle.math.ec.ECPoint normPoint = this.ecPoint.normalize();
            return new ECPoint(normPoint.getAffineXCoord().toBigInteger(), normPoint.getAffineYCoord().toBigInteger());
        }

        public void deserialize(BinaryReader reader) throws DeserializationException {
            try {
                this.ecPoint = this.decodePoint(reader.readBytes(33));
            }
            catch (IOException e) {
                throw new DeserializationException();
            }
        }

        public void serialize(BinaryWriter writer) throws IOException {
            writer.write(this.getEncoded(true));
        }

        public int getSize() {
            return this.ecPoint.isInfinity() ? 1 : 33;
        }

        private org.bouncycastle.math.ec.ECPoint decodePoint(byte[] encodedPoint) {
            return NeoConstants.curve().getCurve().decodePoint(encodedPoint);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            ECPublicKey that = (ECPublicKey)((Object)o);
            return Objects.equals(this.ecPoint, that.ecPoint);
        }

        public int hashCode() {
            return this.ecPoint.hashCode();
        }
    }

    public static class ECPrivateKey {
        private byte[] privateKey;

        public ECPrivateKey(BigInteger key) {
            if (key.toString(16).length() > 64) {
                throw new IllegalArgumentException("Private key must fit into32 bytes, but required " + key.toString(16).length() / 2 + "bytes.");
            }
            this.privateKey = Numeric.toBytesPadded((BigInteger)key, (int)32);
        }

        public ECPrivateKey(byte[] key) {
            if (key.length != 32) {
                throw new IllegalArgumentException("Private key byte array must have length of 32 but had length " + key.length);
            }
            this.privateKey = key;
        }

        public BigInteger getInt() {
            return new BigInteger(1, this.privateKey);
        }

        public byte[] getBytes() {
            return this.privateKey;
        }

        public void erase() {
            for (int i = 0; i < this.privateKey.length; ++i) {
                this.privateKey[i] = 0;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ECPrivateKey that = (ECPrivateKey)o;
            return Arrays.equals(this.privateKey, that.privateKey);
        }

        public int hashCode() {
            return Arrays.hashCode(this.privateKey);
        }
    }
}

