/*
 * Decompiled with CFR 0.152.
 */
package io.mypojo.framework.revision;

import io.mypojo.framework.revision.Revision;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLRevision
implements Revision {
    private static final Logger logger = LoggerFactory.getLogger(URLRevision.class);
    private final URL m_url;
    private final long m_lastModified;

    public URLRevision(URL url, long lastModified) {
        this.m_url = url;
        this.m_lastModified = lastModified > 0L ? lastModified : System.currentTimeMillis();
    }

    @Override
    public long getLastModified() {
        return this.m_lastModified;
    }

    public Enumeration getEntries() {
        return new Properties().elements();
    }

    @Override
    public URL getEntry(String entryName) {
        try {
            return new URL(this.m_url, entryName);
        }
        catch (MalformedURLException e) {
            logger.error("Whilst accessing: " + entryName, (Throwable)e);
            return null;
        }
    }
}

