/*
 * Decompiled with CFR 0.152.
 */
package io.mypojo.framework.revision;

import io.mypojo.framework.revision.EntriesEnumeration;
import io.mypojo.framework.revision.Revision;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarRevision
implements Revision {
    private static final Logger logger = LoggerFactory.getLogger(JarRevision.class);
    private final long m_lastModified;
    private final JarFile m_jar;
    private final URL m_url;
    private final String m_urlString;
    private final String m_prefix;

    public JarRevision(JarFile jar, URL url, String prefix, long lastModified) {
        this.m_jar = jar;
        this.m_url = url;
        this.m_urlString = this.m_url.toExternalForm();
        this.m_prefix = prefix;
        this.m_lastModified = lastModified > 0L ? lastModified : System.currentTimeMillis();
    }

    @Override
    public long getLastModified() {
        return this.m_lastModified;
    }

    public Enumeration getEntries() {
        return new EntriesEnumeration(this.m_jar.entries(), this.m_prefix);
    }

    @Override
    public URL getEntry(String entryName) {
        try {
            if ("/".equals(entryName) || "".equals(entryName) || " ".equals(entryName)) {
                return new URL("jar:" + this.m_urlString + "!/" + (this.m_prefix == null ? "" : this.m_prefix));
            }
            if (entryName != null) {
                final String target = entryName.startsWith("/") ? entryName.substring(1) : entryName;
                final JarEntry entry = this.m_jar.getJarEntry((this.m_prefix == null ? "" : this.m_prefix) + target);
                if (entry != null) {
                    URL result = new URL(null, "jar:" + this.m_urlString + "!/" + (this.m_prefix == null ? "" : this.m_prefix) + target, new URLStreamHandler(){

                        @Override
                        protected URLConnection openConnection(final URL u) throws IOException {
                            return new JarURLConnection(u){

                                @Override
                                public JarFile getJarFile() {
                                    return JarRevision.this.m_jar;
                                }

                                @Override
                                public void connect() throws IOException {
                                }

                                @Override
                                public InputStream getInputStream() throws IOException {
                                    String extF = u.toExternalForm();
                                    JarEntry targetEntry = entry;
                                    if (!extF.endsWith(target)) {
                                        extF = extF.substring(extF.indexOf(33) + 2);
                                        if (JarRevision.this.m_prefix != null && !extF.startsWith(JarRevision.this.m_prefix)) {
                                            extF = JarRevision.this.m_prefix + extF;
                                        }
                                        targetEntry = JarRevision.this.m_jar.getJarEntry(extF);
                                    }
                                    return JarRevision.this.m_jar.getInputStream(targetEntry);
                                }
                            };
                        }
                    });
                    return result;
                }
                if (entryName.endsWith("/")) {
                    return new URL("jar:" + this.m_urlString + "!/" + (this.m_prefix == null ? "" : this.m_prefix) + target);
                }
            }
        }
        catch (IOException e) {
            logger.error("Whilst accessing: " + entryName, (Throwable)e);
        }
        return null;
    }
}

