/*
 * Decompiled with CFR 0.152.
 */
package io.mypojo.framework.launch;

import io.mypojo.felix.framework.util.MapToDictionary;
import io.mypojo.framework.launch.BundleDescriptor;
import io.mypojo.framework.launch.ManifestUtil;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathScanner {
    private static final Logger logger = LoggerFactory.getLogger(ClasspathScanner.class);

    public List<BundleDescriptor> scanForBundles() throws Exception {
        return this.scanForBundles(null, null);
    }

    public List<BundleDescriptor> scanForBundles(ClassLoader loader) throws Exception {
        return this.scanForBundles(null, loader);
    }

    public List<BundleDescriptor> scanForBundles(String filterString) throws Exception {
        return this.scanForBundles(filterString, null);
    }

    public List<BundleDescriptor> scanForBundles(String filterString, ClassLoader loader) throws Exception {
        logger.info("Starting classpath scan");
        Filter filter = filterString != null ? FrameworkUtil.createFilter(filterString) : null;
        ArrayList<BundleDescriptor> bundles = new ArrayList<BundleDescriptor>();
        loader = loader != null ? loader : this.getClass().getClassLoader();
        ArrayList<URL> manifestUrls = Collections.list(loader.getResources("META-INF/MANIFEST.MF"));
        for (URL manifestURL : manifestUrls) {
            Map<String, String> headers = ManifestUtil.getHeaders(manifestURL);
            if (filter != null && !filter.match(new MapToDictionary(headers))) continue;
            bundles.add(new BundleDescriptor(loader, this.getParentURL(manifestURL), headers));
        }
        logger.info("Found {} bundles", (Object)bundles.size());
        return bundles;
    }

    private URL getParentURL(URL url) throws Exception {
        String externalForm = url.toExternalForm();
        return new URL(externalForm.substring(0, externalForm.length() - "META-INF/MANIFEST.MF".length()));
    }
}

