/*
 * Decompiled with CFR 0.152.
 */
package io.mypojo.framework;

import io.mypojo.framework.PojoSRBundle;
import io.mypojo.framework.PojoSRCoreBundle;
import io.mypojo.framework.PojoSRInternals;
import io.mypojo.framework.launch.BundleDescriptor;
import io.mypojo.framework.launch.ClasspathScanner;
import io.mypojo.framework.launch.PojoServiceRegistry;
import io.mypojo.framework.launch.PojoServiceRegistryFactory;
import io.mypojo.framework.launch.impl.PojoServiceRegistryFactoryImpl;
import io.mypojo.framework.revision.DirRevision;
import io.mypojo.framework.revision.JarRevision;
import io.mypojo.framework.revision.Revision;
import io.mypojo.framework.revision.URLRevision;
import io.mypojo.framework.services.BundleStartLevelImpl;
import io.mypojo.framework.services.ConfigurationAdminImpl;
import io.mypojo.framework.services.FrameworkStartLevelImpl;
import io.mypojo.framework.services.LogServiceImpl;
import io.mypojo.framework.services.PackageAdminImpl;
import io.mypojo.framework.services.StartLevelImpl;
import java.io.File;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.log.LogService;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PojoSR
implements PojoServiceRegistry {
    private static final Logger logger = LoggerFactory.getLogger(PojoSR.class);
    private final PojoSRInternals internals = new PojoSRInternals();

    public PojoSR(Map config) throws Exception {
        logger.info("Initialising PojoSR");
        this.internals.bundleConfig.putAll(config);
        PojoSRCoreBundle b = PojoSRCoreBundle.newPojoSRCoreBundle(this.internals, 1);
        this.internals.m_symbolicNameToBundle.put(b.getSymbolicName(), b);
        b.start();
        b.getBundleContext().registerService(StartLevel.class.getName(), (Object)new StartLevelImpl(), null);
        b.getBundleContext().registerService(PackageAdmin.class.getName(), (Object)new PackageAdminImpl(this.internals, b), null);
        b.getBundleContext().registerService(BundleStartLevel.class.getName(), (Object)new BundleStartLevelImpl(), null);
        b.getBundleContext().registerService(FrameworkStartLevel.class.getName(), (Object)new FrameworkStartLevelImpl(), null);
        b.getBundleContext().registerService(LogService.class.getName(), (Object)new LogServiceImpl(), null);
        b.getBundleContext().registerService(ConfigurationAdmin.class.getName(), (Object)new ConfigurationAdminImpl(this.internals), null);
        this.internals.m_context = b.getBundleContext();
        List scan = (List)config.get(PojoServiceRegistryFactory.BUNDLE_DESCRIPTORS);
        if (scan != null) {
            logger.info("Starting bundles");
            this.startBundles(scan);
        }
    }

    public static void main(String[] args) throws Exception {
        Filter filter = null;
        Class<?> main = null;
        for (int i = 0; args != null && i < args.length && i < 2; ++i) {
            try {
                filter = FrameworkUtil.createFilter(args[i]);
                continue;
            }
            catch (InvalidSyntaxException ie) {
                try {
                    main = PojoSR.class.getClassLoader().loadClass(args[i]);
                    continue;
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("Argument is neither a filter nor a class: " + args[i]);
                }
            }
        }
        HashMap<String, List<BundleDescriptor>> config = new HashMap<String, List<BundleDescriptor>>();
        config.put(PojoServiceRegistryFactory.BUNDLE_DESCRIPTORS, filter != null ? new ClasspathScanner().scanForBundles(filter.toString()) : new ClasspathScanner().scanForBundles());
        new PojoServiceRegistryFactoryImpl().newPojoServiceRegistry(config);
        if (main != null) {
            int count = 0;
            if (filter != null) {
                ++count;
            }
            if (main != null) {
                ++count;
            }
            String[] newArgs = args;
            if (count > 0) {
                newArgs = new String[args.length - count];
                System.arraycopy(args, count, newArgs, 0, newArgs.length);
            }
            main.getMethod("main", String[].class).invoke(null, new Object[]{newArgs});
        }
    }

    @Override
    public void startBundles(List<BundleDescriptor> scan) throws Exception {
        for (BundleDescriptor desc : scan) {
            Revision r;
            URL u = new URL(desc.getUrl().toExternalForm() + "META-INF/MANIFEST.MF");
            if (u.toExternalForm().startsWith("file:")) {
                File root = new File(URLDecoder.decode(desc.getUrl().getFile(), "UTF-8"));
                u = root.toURL();
                r = new DirRevision(root);
            } else {
                URLConnection uc = u.openConnection();
                if (uc instanceof JarURLConnection) {
                    String target = ((JarURLConnection)uc).getJarFileURL().toExternalForm();
                    String prefix = null;
                    if (!("jar:" + target + "!/").equals(desc.getUrl().toExternalForm())) {
                        prefix = desc.getUrl().toExternalForm().substring(("jar:" + target + "!/").length());
                    }
                    r = new JarRevision(((JarURLConnection)uc).getJarFile(), ((JarURLConnection)uc).getJarFileURL(), prefix, uc.getLastModified());
                } else {
                    r = new URLRevision(desc.getUrl(), desc.getUrl().openConnection().getLastModified());
                }
            }
            Map<String, String> bundleHeaders = desc.getHeaders();
            Version osgiVersion = null;
            try {
                osgiVersion = Version.parseVersion(bundleHeaders.get("Bundle-Version"));
            }
            catch (Exception ex) {
                logger.error("Error parsing version: " + bundleHeaders.get("Bundle-Version"), (Throwable)ex);
                osgiVersion = Version.emptyVersion;
            }
            String sym = bundleHeaders.get("Bundle-SymbolicName");
            if (sym != null) {
                int idx = sym.indexOf(59);
                if (idx > 0) {
                    sym = sym.substring(0, idx);
                }
                sym = sym.trim();
            }
            if (sym != null && this.internals.m_symbolicNameToBundle.containsKey(sym)) continue;
            boolean core = "osgi.core".equals(sym);
            int id = core ? 0 : this.internals.m_bundles.size();
            PojoSRBundle bundle = new PojoSRBundle(r, bundleHeaders, osgiVersion, desc.getUrl().toExternalForm(), this.internals.m_reg, this.internals.m_dispatcher, bundleHeaders.get("Bundle-Activator"), id, sym, this.internals.m_bundles, desc.getClassLoader(), this.internals.bundleConfig);
            if (sym == null) continue;
            this.internals.m_symbolicNameToBundle.put(bundle.getSymbolicName(), bundle);
        }
        logger.info("Will start {} bundles", (Object)this.internals.m_bundles.size());
        for (long i = 0L; i < (long)this.internals.m_bundles.size(); ++i) {
            try {
                logger.info("Starting {}: {} ", (Object)this.internals.m_bundles.get(i).getBundleId(), (Object)this.internals.m_bundles.get(i).getLocation());
                this.internals.m_bundles.get(i).start();
                continue;
            }
            catch (Throwable e) {
                logger.error("Unable to start bundle: " + i, e);
            }
        }
    }

    @Override
    public BundleContext getBundleContext() {
        return this.internals.m_context;
    }

    @Override
    public void addServiceListener(ServiceListener listener, String filter) throws InvalidSyntaxException {
        this.internals.m_context.addServiceListener(listener, filter);
    }

    @Override
    public void addServiceListener(ServiceListener listener) {
        this.internals.m_context.addServiceListener(listener);
    }

    @Override
    public void removeServiceListener(ServiceListener listener) {
        this.internals.m_context.removeServiceListener(listener);
    }

    @Override
    public ServiceRegistration registerService(String[] clazzes, Object service, Dictionary properties) {
        return this.internals.m_context.registerService(clazzes, service, properties);
    }

    @Override
    public ServiceRegistration registerService(String clazz, Object service, Dictionary properties) {
        return this.internals.m_context.registerService(clazz, service, properties);
    }

    @Override
    public ServiceReference[] getServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        return this.internals.m_context.getServiceReferences(clazz, filter);
    }

    @Override
    public ServiceReference getServiceReference(String clazz) {
        return this.internals.m_context.getServiceReference(clazz);
    }

    @Override
    public Object getService(ServiceReference reference) {
        return this.internals.m_context.getService(reference);
    }

    @Override
    public boolean ungetService(ServiceReference reference) {
        return this.internals.m_context.ungetService(reference);
    }
}

