/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.core.security.encryption;

import io.mosip.kernel.core.security.algorithms.MosipAES;
import io.mosip.kernel.core.security.algorithms.MosipDES;
import io.mosip.kernel.core.security.algorithms.MosipRSA;
import io.mosip.kernel.core.security.algorithms.MosipTWOFISH;
import io.mosip.kernel.core.security.constants.MosipSecurityExceptionCodeConstants;
import io.mosip.kernel.core.security.constants.MosipSecurityMethod;
import io.mosip.kernel.core.security.exception.MosipInvalidDataException;
import io.mosip.kernel.core.security.exception.MosipInvalidKeyException;
import io.mosip.kernel.core.security.exception.MosipNoSuchAlgorithmException;
import io.mosip.kernel.core.security.util.SecurityUtil;

public class MosipEncryptor {
    private MosipEncryptor() {
    }

    public static byte[] asymmetricPrivateEncrypt(byte[] privateKey, byte[] data, MosipSecurityMethod mosipSecurityMethod) throws MosipInvalidDataException, MosipInvalidKeyException {
        SecurityUtil.checkMethod(mosipSecurityMethod);
        switch (mosipSecurityMethod) {
            case HYBRID_RSA_AES_WITH_PKCS1PADDING: {
                return MosipRSA.hybridRsaAesWithPKCS1Padding(SecurityUtil.bytesToPrivateKey(privateKey), data, true);
            }
            case HYBRID_RSA_AES_WITH_OAEP_WITH_MD5_AND_MGF1PADDING: {
                return MosipRSA.hybridRsaAesWithOAEPWithMD5AndMGF1Padding(SecurityUtil.bytesToPrivateKey(privateKey), data, true);
            }
            case HYBRID_RSA_AES_WITH_OAEP_WITH_SHA3512_AND_MGF1PADDING: {
                return MosipRSA.hybridRsaAesWithOAEPWithSHA3512AndMGF1Padding(SecurityUtil.bytesToPrivateKey(privateKey), data, true);
            }
            case RSA_WITH_PKCS1PADDING: {
                return MosipRSA.rsaWithPKCS1Padding(SecurityUtil.bytesToPrivateKey(privateKey), data, true);
            }
            case RSA_WITH_OAEP_WITH_MD5_AND_MGF1PADDING: {
                return MosipRSA.rsaWithOAEPWithMD5AndMGF1Padding(SecurityUtil.bytesToPrivateKey(privateKey), data, true);
            }
            case RSA_WITH_OAEP_WITH_SHA3512_AND_MGF1PADDING: {
                return MosipRSA.rsaWithOAEPWithSHA3512AndMGF1Padding(SecurityUtil.bytesToPrivateKey(privateKey), data, true);
            }
        }
        throw new MosipNoSuchAlgorithmException(MosipSecurityExceptionCodeConstants.MOSIP_NO_SUCH_ALGORITHM_EXCEPTION);
    }

    public static byte[] asymmetricPublicEncrypt(byte[] publicKey, byte[] data, MosipSecurityMethod mosipSecurityMethod) throws MosipInvalidDataException, MosipInvalidKeyException {
        SecurityUtil.checkMethod(mosipSecurityMethod);
        switch (mosipSecurityMethod) {
            case HYBRID_RSA_AES_WITH_PKCS1PADDING: {
                return MosipRSA.hybridRsaAesWithPKCS1Padding(SecurityUtil.bytesToPublicKey(publicKey), data, true);
            }
            case HYBRID_RSA_AES_WITH_OAEP_WITH_MD5_AND_MGF1PADDING: {
                return MosipRSA.hybridRsaAesWithOAEPWithMD5AndMGF1Padding(SecurityUtil.bytesToPublicKey(publicKey), data, true);
            }
            case HYBRID_RSA_AES_WITH_OAEP_WITH_SHA3512_AND_MGF1PADDING: {
                return MosipRSA.hybridRsaAesWithOAEPWithSHA3512AndMGF1Padding(SecurityUtil.bytesToPublicKey(publicKey), data, true);
            }
            case RSA_WITH_PKCS1PADDING: {
                return MosipRSA.rsaWithPKCS1Padding(SecurityUtil.bytesToPublicKey(publicKey), data, true);
            }
            case RSA_WITH_OAEP_WITH_MD5_AND_MGF1PADDING: {
                return MosipRSA.rsaWithOAEPWithMD5AndMGF1Padding(SecurityUtil.bytesToPublicKey(publicKey), data, true);
            }
            case RSA_WITH_OAEP_WITH_SHA3512_AND_MGF1PADDING: {
                return MosipRSA.rsaWithOAEPWithSHA3512AndMGF1Padding(SecurityUtil.bytesToPublicKey(publicKey), data, true);
            }
        }
        throw new MosipNoSuchAlgorithmException(MosipSecurityExceptionCodeConstants.MOSIP_NO_SUCH_ALGORITHM_EXCEPTION);
    }

    public static byte[] symmetricEncrypt(byte[] key, byte[] data, MosipSecurityMethod mosipSecurityMethod) throws MosipInvalidDataException, MosipInvalidKeyException {
        SecurityUtil.checkMethod(mosipSecurityMethod);
        switch (mosipSecurityMethod) {
            case AES_WITH_CBC_AND_PKCS7PADDING: {
                return MosipAES.aesWithCBCandPKCS7Padding(key, data, true);
            }
            case DES_WITH_CBC_AND_PKCS7PADDING: {
                return MosipDES.desWithCBCandPKCS7Padding(key, data, true);
            }
            case TWOFISH_WITH_CBC_AND_PKCS7PADDING: {
                return MosipTWOFISH.twoFishWithCBCandPKCS7Padding(key, data, true);
            }
        }
        throw new MosipNoSuchAlgorithmException(MosipSecurityExceptionCodeConstants.MOSIP_NO_SUCH_ALGORITHM_EXCEPTION);
    }
}

