/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.core.exception;

import io.mosip.kernel.core.exception.ExceptionUtils;
import io.mosip.kernel.core.exception.InfoItem;
import java.util.ArrayList;
import java.util.List;

public class BaseUncheckedException
extends RuntimeException {
    private static final long serialVersionUID = -875003872780128394L;
    public static final String EMPTY_SPACE = " ";
    private final List<InfoItem> infoItems = new ArrayList<InfoItem>();

    public BaseUncheckedException() {
    }

    public BaseUncheckedException(String errorMessage) {
        super(errorMessage);
    }

    public BaseUncheckedException(String errorCode, String errorMessage) {
        super(errorCode + " --> " + errorMessage);
        this.addInfo(errorCode, errorMessage);
    }

    public BaseUncheckedException(String errorCode, String errorMessage, Throwable rootCause) {
        super(errorCode + " --> " + errorMessage, rootCause);
        this.addInfo(errorCode, errorMessage);
        if (rootCause instanceof BaseUncheckedException) {
            BaseUncheckedException bue = (BaseUncheckedException)rootCause;
            this.infoItems.addAll(bue.infoItems);
        }
    }

    @Override
    public String getMessage() {
        return ExceptionUtils.buildMessage(super.getMessage(), this.getCause());
    }

    public BaseUncheckedException addInfo(String errorCode, String errorText) {
        this.infoItems.add(new InfoItem(errorCode, errorText));
        return this;
    }

    public List<String> getCodes() {
        ArrayList<String> codes = new ArrayList<String>();
        for (int i = this.infoItems.size() - 1; i >= 0; --i) {
            codes.add(this.infoItems.get((int)i).errorCode);
        }
        return codes;
    }

    public List<String> getErrorTexts() {
        ArrayList<String> errorTexts = new ArrayList<String>();
        for (int i = this.infoItems.size() - 1; i >= 0; --i) {
            errorTexts.add(this.infoItems.get((int)i).errorText);
        }
        return errorTexts;
    }

    public String getErrorCode() {
        return this.infoItems.get((int)0).errorCode;
    }

    public String getErrorText() {
        return this.infoItems.get((int)0).errorText;
    }
}

