/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.driver.mongodb.reactive.util;

import com.mongodb.MongoNamespace;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.InsertOneResult;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.MongoCollection;
import io.mongock.driver.mongodb.reactive.util.MongoIterable;
import io.mongock.driver.mongodb.reactive.util.MongoSubscriberSync;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoCollectionSync {
    private final MongoCollection<Document> collection;

    public MongoCollectionSync(MongoCollection<Document> collection) {
        this.collection = collection;
    }

    public MongoCollection<Document> getCollection() {
        return this.collection;
    }

    public MongoIterable<Document> find() {
        return this.find((Bson)new BsonDocument());
    }

    public MongoIterable<Document> find(Bson bson) {
        MongoSubscriberSync subscriber = new MongoSubscriberSync();
        this.collection.find(bson).subscribe(subscriber);
        return subscriber.get();
    }

    public List<Document> listIndexes() {
        MongoSubscriberSync subscriber = new MongoSubscriberSync();
        this.collection.listIndexes().subscribe(subscriber);
        return subscriber.get();
    }

    public String createIndex(Bson keys, IndexOptions indexOptions) {
        MongoSubscriberSync subscriber = new MongoSubscriberSync();
        this.collection.createIndex(keys, indexOptions).subscribe(subscriber);
        return (String)subscriber.get().first();
    }

    public MongoNamespace getNamespace() {
        return this.collection.getNamespace();
    }

    public void dropIndex(String indexName) {
        MongoSubscriberSync subscriber = new MongoSubscriberSync();
        this.collection.dropIndex(indexName).subscribe(subscriber);
        subscriber.await();
    }

    public DeleteResult deleteMany(Bson filter) {
        MongoSubscriberSync subscriber = new MongoSubscriberSync();
        this.collection.deleteMany(filter).subscribe(subscriber);
        return (DeleteResult)subscriber.get().first();
    }

    public UpdateResult updateMany(Bson filter, Bson update, UpdateOptions updateOptions) {
        MongoSubscriberSync subscriber = new MongoSubscriberSync();
        this.collection.updateMany(filter, update, updateOptions).subscribe(subscriber);
        return (UpdateResult)subscriber.get().first();
    }

    public UpdateResult replaceOne(ClientSession clientSession, Bson filter, Document replacement, ReplaceOptions replaceOptions) {
        MongoSubscriberSync subscriber = new MongoSubscriberSync();
        this.collection.replaceOne(clientSession, filter, (Object)replacement, replaceOptions).subscribe(subscriber);
        return (UpdateResult)subscriber.get().first();
    }

    public UpdateResult replaceOne(Bson filter, Document replacement, ReplaceOptions replaceOptions) {
        MongoSubscriberSync subscriber = new MongoSubscriberSync();
        this.collection.replaceOne(filter, (Object)replacement, replaceOptions).subscribe(subscriber);
        return (UpdateResult)subscriber.get().first();
    }

    public long countDocuments(Bson filter) {
        MongoSubscriberSync subscriber = new MongoSubscriberSync();
        this.collection.countDocuments(filter).subscribe(subscriber);
        return (Long)subscriber.getFirst();
    }

    public InsertOneResult insertOne(Document document) {
        MongoSubscriberSync subscriber = new MongoSubscriberSync();
        this.collection.insertOne((Object)document).subscribe(subscriber);
        return (InsertOneResult)subscriber.getFirst();
    }
}

