/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.driver.mongodb.reactive.driver;

import com.mongodb.MongoClientException;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.MongoClient;
import io.mongock.api.exception.MongockException;
import io.mongock.driver.api.driver.ChangeSetDependency;
import io.mongock.driver.api.driver.Transactional;
import io.mongock.driver.mongodb.reactive.driver.MongoReactiveDriverGeneric;
import io.mongock.driver.mongodb.reactive.util.MongoSubscriberSync;
import io.mongock.utils.annotation.NotThreadSafe;
import java.util.Optional;
import java.util.Set;
import org.reactivestreams.Publisher;

@NotThreadSafe
public abstract class MongoReactiveDriverBase
extends MongoReactiveDriverGeneric {
    private final MongoClient mongoClient;
    protected ClientSession clientSession;

    protected MongoReactiveDriverBase(MongoClient mongoClient, String databaseName, long lockAcquiredForMillis, long lockQuitTryingAfterMillis, long lockTryFrequencyMillis) {
        super(mongoClient.getDatabase(databaseName), lockAcquiredForMillis, lockQuitTryingAfterMillis, lockTryFrequencyMillis);
        this.mongoClient = mongoClient;
    }

    public void prepareForExecutionBlock() {
        try {
            MongoSubscriberSync subscriber = new MongoSubscriberSync();
            this.mongoClient.startSession().subscribe(subscriber);
            this.clientSession = (ClientSession)subscriber.getFirst();
        }
        catch (MongoClientException ex) {
            throw new MongockException("ERROR starting session. If Mongock is connected to a MongoDB cluster which doesn't support transactions, you must to disable transactions", (Exception)((Object)ex));
        }
    }

    public Set<ChangeSetDependency> getDependencies() {
        Set dependencies = super.getDependencies();
        if (this.clientSession != null) {
            ChangeSetDependency clientSessionDependency = new ChangeSetDependency(ClientSession.class, (Object)this.clientSession, false);
            dependencies.remove(clientSessionDependency);
            dependencies.add(clientSessionDependency);
        }
        return dependencies;
    }

    public void executeInTransaction(Runnable operation) {
        try {
            this.changeEntryRepository.setClientSession(this.clientSession);
            this.clientSession.startTransaction(this.txOptions);
            operation.run();
            this.voidSubscribe((Publisher<Void>)this.clientSession.commitTransaction());
        }
        catch (Exception ex) {
            this.voidSubscribe((Publisher<Void>)this.clientSession.abortTransaction());
            throw new MongockException((Throwable)ex);
        }
        finally {
            this.changeEntryRepository.clearClientSession();
            this.clientSession.close();
        }
    }

    private MongoSubscriberSync<Void> voidSubscribe(Publisher<Void> voidPublisher) {
        MongoSubscriberSync subscriber = new MongoSubscriberSync();
        voidPublisher.subscribe(subscriber);
        return subscriber.await();
    }

    public Optional<Transactional> getTransactioner() {
        return Optional.ofNullable(this.transactionEnabled ? this : null);
    }
}

