/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.driver.core.lock;

import io.mongock.driver.api.lock.LockCheckException;
import io.mongock.driver.api.lock.LockManager;
import io.mongock.driver.core.lock.LockEntry;
import io.mongock.driver.core.lock.LockPersistenceException;
import io.mongock.driver.core.lock.LockRepository;
import io.mongock.driver.core.lock.LockStatus;
import io.mongock.utils.TimeService;
import io.mongock.utils.annotation.NotThreadSafe;
import java.time.Instant;
import java.util.Date;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class LockManagerDefault
extends Thread
implements LockManager {
    private static final Logger logger = LoggerFactory.getLogger(LockManagerDefault.class);
    private static final String GOING_TO_SLEEP_MSG = "Mongock is going to sleep to wait for the lock:  {} ms({} minutes)";
    private static final String EXPIRATION_ARG_ERROR_MSG = "Lock expiration period must be greater than %d ms";
    private static final String MAX_TRIES_ERROR_TEMPLATE = "Quit trying lock after %s millis due to LockPersistenceException: \n\tcurrent lock:  %s\n\tnew lock: %s\n\tacquireLockQuery: %s\n\tdb error detail: %s";
    private static final String LOCK_HELD_BY_OTHER_PROCESS = "Lock held by other process. Cannot ensure lock.\n\tcurrent lock:  %s\n\tnew lock: %s\n\tacquireLockQuery: %s\n\tdb error detail: %s";
    private static final long MIN_LOCK_ACQUIRED_FOR_MILLIS = 3000L;
    private static final long DEFAULT_LOCK_ACQUIRED_FOR_MILLIS = 60000L;
    private static final long DEFAULT_QUIT_TRY_AFTER_MILLIS = 180000L;
    private static final double LOCK_REFRESH_MARGIN_PERCENTAGE = 0.33;
    private static final long MIN_LOCK_REFRESH_MARGIN_MILLIS = 1000L;
    private static final long DEFAULT_LOCK_REFRESH_MARGIN_MILLIS = 19800L;
    private static final long MINIMUM_WAITING_TO_TRY_AGAIN = 500L;
    private static final long DEFAULT_TRY_FREQUENCY_MILLIS = 1000L;
    private static final String DEFAULT_KEY = "DEFAULT_KEY";
    private final boolean daemonActive;
    private volatile Date lockExpiresAt = null;
    private volatile Instant shouldStopTryingAt;
    private volatile boolean releaseStarted = false;
    private final Object releaseMutex = new Object();
    private final LockRepository repository;
    private final TimeService timeService;
    private final String owner;
    private final long lockAcquiredForMillis;
    private final long lockTryFrequencyMillis;
    private final long lockRefreshMarginMillis;
    private final long lockQuitTryingAfterMillis;

    public static DefaultLockManagerBuilder builder() {
        return new DefaultLockManagerBuilder();
    }

    private LockManagerDefault(LockRepository repository, TimeService timeService, long lockAcquiredForMillis, long lockQuitTryingAfterMillis, long lockTryFrequencyMillis, long lockRefreshMarginMillis, String owner, boolean daemonActive) {
        this.repository = repository;
        this.timeService = timeService;
        this.lockAcquiredForMillis = lockAcquiredForMillis;
        this.lockQuitTryingAfterMillis = lockQuitTryingAfterMillis;
        this.lockTryFrequencyMillis = lockTryFrequencyMillis;
        this.lockRefreshMarginMillis = lockRefreshMarginMillis;
        this.owner = owner;
        this.daemonActive = daemonActive;
        this.setDaemon(true);
    }

    public String getDefaultKey() {
        return DEFAULT_KEY;
    }

    public void acquireLockDefault() throws LockCheckException {
        this.initialize();
        boolean keepLooping = true;
        do {
            try {
                logger.info("Mongock trying to acquire the lock");
                Date newLockExpiresAt = this.timeService.currentDatePlusMillis(this.lockAcquiredForMillis);
                this.repository.insertUpdate(new LockEntry(this.getDefaultKey(), LockStatus.LOCK_HELD.name(), this.owner, newLockExpiresAt));
                logger.info("Mongock acquired the lock until: {}", (Object)newLockExpiresAt);
                this.updateStatus(newLockExpiresAt);
                keepLooping = false;
                this.startThreadIfApplies();
            }
            catch (LockPersistenceException ex) {
                this.handleLockException(true, ex);
            }
        } while (keepLooping);
    }

    public void ensureLockDefault() throws LockCheckException {
        block4: {
            logger.debug("Ensuring the lock");
            if (this.releaseStarted) {
                throw new LockCheckException("Lock cannot be ensured after being cancelled");
            }
            while (this.needsRefreshLock()) {
                logger.debug("Lock refreshing required");
                try {
                    this.refreshLock();
                    break block4;
                }
                catch (LockPersistenceException ex) {
                    this.handleLockException(false, ex);
                }
            }
            logger.debug("Dont need to refresh the lock at[{}], acquired until: {}", (Object)this.timeService.currentTime(), (Object)this.lockExpiresAt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.info("Starting mongock lock daemon...");
        while (!this.releaseStarted) {
            try {
                logger.debug("Mongock(daemon) ensuring lock");
                Object object = this.releaseMutex;
                synchronized (object) {
                    if (!this.releaseStarted) {
                        this.refreshLock();
                    }
                }
            }
            catch (LockCheckException e) {
                logger.warn("Mongock(daemon)Error ensuring the lock from daemon: {}", (Object)e.getMessage());
            }
            catch (Exception e) {
                logger.warn("Mongock(daemon)Generic error from daemon: {}", (Object)e.getMessage());
            }
            if (this.releaseStarted) continue;
            this.reposeIfRequired();
        }
        logger.info("Cancelled mongock lock daemon");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLockDefault() {
        logger.info("Mongock releasing the lock");
        this.releaseStarted = true;
        Object object = this.releaseMutex;
        synchronized (object) {
            try {
                logger.info("Mongock releasing the lock");
                this.repository.removeByKeyAndOwner(this.getDefaultKey(), this.getOwner());
                this.lockExpiresAt = null;
                this.shouldStopTryingAt = Instant.now();
                logger.info("Mongock released the lock");
            }
            catch (Exception ex) {
                logger.warn("Error removing the lock from database", (Throwable)ex);
            }
        }
    }

    public void close() {
        this.releaseLockDefault();
    }

    public boolean isReleaseStarted() {
        return this.releaseStarted;
    }

    public long getLockTryFrequency() {
        return this.lockTryFrequencyMillis;
    }

    public String getOwner() {
        return this.owner;
    }

    public boolean isLockHeld() {
        return this.lockExpiresAt != null && this.timeService.currentTime().compareTo(this.lockExpiresAt) < 1;
    }

    private void refreshLock() {
        logger.debug("Mongock trying to refresh the lock");
        Date lockExpiresAtTemp = this.timeService.currentDatePlusMillis(this.lockAcquiredForMillis);
        LockEntry lockEntry = new LockEntry(this.getDefaultKey(), LockStatus.LOCK_HELD.name(), this.owner, lockExpiresAtTemp);
        this.repository.updateIfSameOwner(lockEntry);
        this.updateStatus(lockExpiresAtTemp);
        logger.debug("Mongock refreshed the lock until: {}", (Object)lockExpiresAtTemp);
    }

    private void reposeIfRequired() {
        try {
            long reposingTime = this.getDaemonTimeSleep();
            logger.debug("Mongock lock daemon sleeping for {}ms", (Object)reposingTime);
            LockManagerDefault.sleep(reposingTime);
        }
        catch (InterruptedException ex) {
            logger.warn("Interrupted exception ignored");
        }
    }

    private long getDaemonTimeSleep() {
        long baseSleepMillis;
        logger.debug("Calculating millis for lock daemon to sleep");
        if (this.lockExpiresAt != null) {
            Date nowDate = this.timeService.currentTime();
            long millisToRefresh = this.lockExpiresAt.getTime() - nowDate.getTime();
            logger.debug("Difference now[{}] and Lock's expiry-date[{}]: {}ms ", new Object[]{nowDate, this.lockExpiresAt.toString(), millisToRefresh});
            baseSleepMillis = millisToRefresh < this.lockRefreshMarginMillis && millisToRefresh > 0L ? millisToRefresh : this.lockAcquiredForMillis;
        } else {
            logger.debug("Taking lockAcquireForMillis[{}ms] as base to calculate daemon's sleep time", (Object)this.lockAcquiredForMillis);
            baseSleepMillis = this.lockAcquiredForMillis;
        }
        return new Double((double)baseSleepMillis * 0.33).longValue();
    }

    private void handleLockException(boolean acquiringLock, LockPersistenceException ex) {
        LockEntry currentLock = this.repository.findByKey(this.getDefaultKey());
        if (this.isAcquisitionTimerOver()) {
            this.updateStatus(null);
            throw new LockCheckException(String.format(MAX_TRIES_ERROR_TEMPLATE, this.lockQuitTryingAfterMillis, currentLock != null ? currentLock.toString() : "none", ex.getNewLockEntity(), ex.getAcquireLockQuery(), ex.getDbErrorDetail()));
        }
        if (this.isLockOwnedByOtherProcess(currentLock)) {
            Date currentLockExpiresAt = currentLock.getExpiresAt();
            logger.warn("Lock is taken by other process until: {}", (Object)currentLockExpiresAt);
            if (!acquiringLock) {
                throw new LockCheckException(String.format(LOCK_HELD_BY_OTHER_PROCESS, currentLock, ex.getNewLockEntity(), ex.getAcquireLockQuery(), ex.getDbErrorDetail()));
            }
            this.waitForLock(currentLockExpiresAt);
        }
    }

    private boolean isLockOwnedByOtherProcess(LockEntry currentLock) {
        return currentLock != null && !currentLock.isOwner(this.owner);
    }

    private void waitForLock(Date expiresAtMillis) {
        Date current = this.timeService.currentTime();
        long currentLockWillExpireInMillis = expiresAtMillis.getTime() - current.getTime();
        long sleepingMillis = this.lockTryFrequencyMillis;
        if (this.lockTryFrequencyMillis > currentLockWillExpireInMillis) {
            logger.info("The configured time frequency[{} millis] is higher than the current lock's expiration", (Object)this.lockTryFrequencyMillis);
            sleepingMillis = currentLockWillExpireInMillis > 500L ? currentLockWillExpireInMillis : 500L;
        }
        logger.info("Mongock will try to acquire the lock in {} mills", (Object)sleepingMillis);
        try {
            logger.info(GOING_TO_SLEEP_MSG, (Object)sleepingMillis, (Object)this.timeService.millisToMinutes(sleepingMillis));
            Thread.sleep(sleepingMillis);
        }
        catch (InterruptedException ex) {
            logger.error("ERROR acquiring the lock", (Throwable)ex);
            Thread.currentThread().interrupt();
        }
    }

    private boolean needsRefreshLock() {
        Date expirationWithMargin;
        if (this.lockExpiresAt == null) {
            return true;
        }
        Date currentTime = this.timeService.currentTime();
        return currentTime.compareTo(expirationWithMargin = new Date(this.lockExpiresAt.getTime() - this.lockRefreshMarginMillis)) >= 0;
    }

    private void updateStatus(Date lockExpiresAt) {
        this.lockExpiresAt = lockExpiresAt;
        this.finishAcquisitionTimer();
    }

    private synchronized void initialize() {
        if (this.releaseStarted) {
            throw new LockCheckException("Lock cannot be acquired after being cancelled");
        }
        if (this.shouldStopTryingAt == null) {
            this.shouldStopTryingAt = this.timeService.nowPlusMillis(this.lockQuitTryingAfterMillis);
        }
    }

    private synchronized void startThreadIfApplies() {
        if (this.daemonActive) {
            super.start();
        }
    }

    @Override
    public synchronized void start() {
        throw new UnsupportedOperationException("Start method not supported");
    }

    private void finishAcquisitionTimer() {
        this.shouldStopTryingAt = null;
    }

    private boolean isAcquisitionTimerOver() {
        return this.shouldStopTryingAt == null || this.timeService.isPast(this.shouldStopTryingAt);
    }

    public static class DefaultLockManagerBuilder {
        private LockRepository lockRepository;
        private long lockAcquiredForMillis = 60000L;
        private long lockTryFrequencyMillis = 1000L;
        private long lockRefreshMarginMillis = 19800L;
        private long lockQuitTryingAfterMillis = 180000L;
        private String owner = UUID.randomUUID().toString();
        private TimeService timeService;
        private boolean background = true;

        public DefaultLockManagerBuilder setLockQuitTryingAfterMillis(long millis) {
            if (millis <= 0L) {
                throw new IllegalArgumentException("Lock-quit-trying-after must be grater than 0 ");
            }
            this.lockQuitTryingAfterMillis = millis;
            return this;
        }

        public DefaultLockManagerBuilder setLockTryFrequencyMillis(long millis) {
            if (millis < 500L) {
                throw new IllegalArgumentException(String.format("Lock-try-frequency must be grater than %d", 500L));
            }
            this.lockTryFrequencyMillis = millis;
            return this;
        }

        public DefaultLockManagerBuilder setLockAcquiredForMillis(long millis) {
            if (millis < 3000L) {
                throw new IllegalArgumentException(String.format(LockManagerDefault.EXPIRATION_ARG_ERROR_MSG, 3000L));
            }
            this.lockAcquiredForMillis = millis;
            long marginTemp = (long)((double)this.lockAcquiredForMillis * 0.33);
            this.lockRefreshMarginMillis = Math.max(marginTemp, 1000L);
            return this;
        }

        public DefaultLockManagerBuilder setLockRepository(LockRepository lockRepository) {
            this.lockRepository = lockRepository;
            return this;
        }

        public DefaultLockManagerBuilder setTimeService(TimeService timeService) {
            this.timeService = timeService;
            return this;
        }

        public DefaultLockManagerBuilder setOwner(String owner) {
            this.owner = owner;
            return this;
        }

        public DefaultLockManagerBuilder disableBackGround() {
            this.background = false;
            return this;
        }

        public LockManagerDefault build() {
            return new LockManagerDefault(this.lockRepository, this.timeService != null ? this.timeService : new TimeService(), this.lockAcquiredForMillis, this.lockQuitTryingAfterMillis, this.lockTryFrequencyMillis, this.lockRefreshMarginMillis, this.owner, this.background);
        }
    }
}

