/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.java.spring.boot3;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.RemoveAnnotationAttribute;
import org.openrewrite.java.trait.Traits;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class RemoveReplaceNoneFromAutoConfigureTestDatabase
extends Recipe {
    private static final String AUTO_CONFIGURE_TEST_DATABASE = "org.springframework.boot.test.autoconfigure.jdbc.AutoConfigureTestDatabase";

    public String getDisplayName() {
        return "Remove `Replace.NONE` from `@AutoConfigureTestDatabase`";
    }

    public String getDescription() {
        return "`Replace.NONE` is the default value for `@AutoConfigureTestDatabase` since Spring Boot 3.4.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Traits.annotated((String)"@org.springframework.boot.test.autoconfigure.jdbc.AutoConfigureTestDatabase").asVisitor((a, ctx) -> {
            J.Annotation annotation = (J.Annotation)a.getTree();
            if (this.hasReplacementNone(annotation)) {
                return new RemoveAnnotationAttribute(AUTO_CONFIGURE_TEST_DATABASE, "replace").getVisitor().visit((Tree)annotation, ctx);
            }
            return annotation;
        });
    }

    private boolean hasReplacementNone(J.Annotation annotation) {
        if (annotation.getArguments() != null) {
            for (Expression argument : annotation.getArguments()) {
                J.Assignment assignment;
                if (!(argument instanceof J.Assignment) || !"replace".equals(((J.Identifier)(assignment = (J.Assignment)argument).getVariable()).getSimpleName())) continue;
                Expression assigned = assignment.getAssignment();
                if (assigned instanceof J.Identifier) {
                    return "NONE".equals(((J.Identifier)assigned).getSimpleName());
                }
                if (!(assigned instanceof J.FieldAccess)) continue;
                return "NONE".equals(((J.FieldAccess)assigned).getSimpleName());
            }
        }
        return false;
    }
}

