/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.java.spring.boot3;

import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public final class ConditionalOnAvailableEndpointMigrationSpring34
extends Recipe {
    private static final String CONDITIONAL_ON_AVAILABLE_ENDPOINT_FQN = "org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint";
    private static final String ENDPOINT_EXPOSURE_FQN = "org.springframework.boot.actuate.autoconfigure.endpoint.expose.EndpointExposure";
    private static final AnnotationMatcher AS_VALUE = new AnnotationMatcher("org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint(org.springframework.boot.actuate.autoconfigure.endpoint.expose.EndpointExposure.CLOUD_FOUNDRY)", Boolean.valueOf(false));
    private static final AnnotationMatcher AS_EXPOSURE = new AnnotationMatcher("org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint(exposure=org.springframework.boot.actuate.autoconfigure.endpoint.expose.EndpointExposure.CLOUD_FOUNDRY)", Boolean.valueOf(false));

    public String getDisplayName() {
        return "Migrate `ConditionalOnAvailableEndpoint` for Spring Boot 3.4";
    }

    public String getDescription() {
        return "Migrate `@ConditionalOnAvailableEndpoint(EndpointExposure.CLOUD_FOUNDRY)` to `@ConditionalOnAvailableEndpoint(EndpointExposure.WEB)` for Spring Boot 3.4.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType(CONDITIONAL_ON_AVAILABLE_ENDPOINT_FQN, Boolean.valueOf(false)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
                if (AS_VALUE.matches(annotation) || AS_EXPOSURE.matches(annotation)) {
                    List arguments = annotation.getArguments();
                    if (arguments == null || arguments.isEmpty()) {
                        return annotation;
                    }
                    J.Annotation tmpAnno = super.visitAnnotation(annotation, (Object)ctx);
                    arguments = ListUtils.map((List)arguments, it -> this.maybeReplaceAttributeValue(Objects.requireNonNull(it), tmpAnno));
                    J.Annotation finalAnnotation = annotation.withArguments(arguments);
                    this.maybeAddImport(ConditionalOnAvailableEndpointMigrationSpring34.ENDPOINT_EXPOSURE_FQN);
                    finalAnnotation = (J.Annotation)this.maybeAutoFormat((J)annotation, (J)finalAnnotation, ctx);
                    return finalAnnotation;
                }
                return annotation;
            }

            private Expression maybeReplaceAttributeValue(Expression it, J.Annotation annotation) {
                if (it instanceof J.Assignment) {
                    String attributeName = ((J.Identifier)((J.Assignment)it).getVariable()).getSimpleName();
                    if ("exposure".equals(attributeName) || "value".equals(attributeName)) {
                        Expression newInitializer = this.maybeReplaceAttributeValue(((J.Assignment)it).getAssignment(), annotation);
                        return ((J.Assignment)it).withAssignment(newInitializer);
                    }
                } else if (it instanceof J.FieldAccess) {
                    if (((J.FieldAccess)it).getSimpleName().equals("CLOUD_FOUNDRY")) {
                        return (Expression)Objects.requireNonNull(((J.Annotation)JavaTemplate.builder((String)"EndpointExposure.WEB").javaParser(JavaParser.fromJavaVersion().dependsOn(new String[]{"package org.springframework.boot.actuate.autoconfigure.endpoint.expose;\npublic enum EndpointExposure { JMX,WEB }"})).imports(new String[]{ConditionalOnAvailableEndpointMigrationSpring34.ENDPOINT_EXPOSURE_FQN}).build().apply(this.getCursor(), annotation.getCoordinates().replaceArguments(), new Object[0])).getArguments()).get(0);
                    }
                } else if (it instanceof J.NewArray) {
                    J.NewArray array = (J.NewArray)it;
                    List initializer = ((J.NewArray)it).getInitializer();
                    initializer = ListUtils.map((List)initializer, init -> this.maybeReplaceAttributeValue(Objects.requireNonNull(init), annotation));
                    return array.withInitializer(initializer);
                }
                return it;
            }
        });
    }

    @Generated
    public ConditionalOnAvailableEndpointMigrationSpring34() {
    }

    @Generated
    public String toString() {
        return "ConditionalOnAvailableEndpointMigrationSpring34()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConditionalOnAvailableEndpointMigrationSpring34)) {
            return false;
        }
        ConditionalOnAvailableEndpointMigrationSpring34 other = (ConditionalOnAvailableEndpointMigrationSpring34)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ConditionalOnAvailableEndpointMigrationSpring34;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

