/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.recipe.spring.boot3;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.spring.ChangeSpringPropertyKey;
import org.openrewrite.java.spring.ChangeSpringPropertyValue;
import org.openrewrite.properties.search.FindProperties;
import org.openrewrite.properties.tree.Properties;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class MigrateEndpointAccessValueSpring34
extends ScanningRecipe<Set<String>> {
    private static final String ENABLED_REGEX = "management\\.endpoint\\.(\\w+)\\.enabled";
    private static final String endpointEnabled = "management.endpoint.*.enabled";

    public String getDisplayName() {
        return "Migrate management endpoint access value";
    }

    public String getDescription() {
        return "Migrate manage endpoint access value from `false` to `none` and `true` to `read-only`.";
    }

    public Set<String> getInitialValue(ExecutionContext ctx) {
        return new HashSet<String>();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Set<String> acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if ((tree = super.visit(tree, (Object)ctx)) instanceof Properties.File) {
                    acc.addAll(this.collectFromProperties((Properties)tree));
                } else if (tree instanceof Yaml.Documents) {
                    acc.addAll(this.collectFromYaml(tree, ctx));
                }
                return tree;
            }

            private Set<String> collectFromProperties(Properties tree) {
                HashSet<String> endpoints = new HashSet<String>();
                for (Properties.Entry entry : FindProperties.find((Properties)tree, (String)MigrateEndpointAccessValueSpring34.endpointEnabled, null)) {
                    endpoints.add(entry.getKey());
                }
                return endpoints;
            }

            private Set<String> collectFromYaml(Tree tree, ExecutionContext ctx) {
                return (Set)new YamlIsoVisitor<Set<String>>(){

                    public Yaml.Scalar visitScalar(Yaml.Scalar scalar, Set<String> set) {
                        scalar = super.visitScalar(scalar, set);
                        String currentLocation = this.getYamlPropertyKey(this.getCursor());
                        if (currentLocation.matches(MigrateEndpointAccessValueSpring34.ENABLED_REGEX)) {
                            set.add(currentLocation);
                        }
                        return scalar;
                    }
                }.reduce(tree, new HashSet());
            }

            private String getYamlPropertyKey(Cursor cursor) {
                StringBuilder asProperty = new StringBuilder();
                Iterator path = cursor.getPath();
                int i = 0;
                while (path.hasNext()) {
                    Object next = path.next();
                    if (!(next instanceof Yaml.Mapping.Entry)) continue;
                    Yaml.Mapping.Entry entry = (Yaml.Mapping.Entry)next;
                    if (i++ > 0) {
                        asProperty.insert(0, '.');
                    }
                    asProperty.insert(0, entry.getKey().getValue());
                }
                return asProperty.toString();
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final Set<String> acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                tree = super.visit(tree, (Object)ctx);
                for (String oldKey : acc) {
                    int lastDot = oldKey.lastIndexOf(46);
                    String newKey = oldKey.substring(0, lastDot) + ".access";
                    tree = new ChangeSpringPropertyValue(oldKey, "none", "false", null, null).getVisitor().visit(tree, (Object)ctx);
                    tree = new ChangeSpringPropertyValue(oldKey, "read-only", "true", null, null).getVisitor().visit(tree, (Object)ctx);
                    tree = new ChangeSpringPropertyKey(oldKey, newKey, null).getVisitor().visit(tree, (Object)ctx);
                }
                return tree;
            }
        };
    }

    @Generated
    public MigrateEndpointAccessValueSpring34() {
    }

    @Generated
    public String toString() {
        return "MigrateEndpointAccessValueSpring34()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MigrateEndpointAccessValueSpring34)) {
            return false;
        }
        MigrateEndpointAccessValueSpring34 other = (MigrateEndpointAccessValueSpring34)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MigrateEndpointAccessValueSpring34;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

