/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.recipe.spring.boot3;

import java.util.List;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.marker.Markers;

public final class CommentOnMockAndSpyBeansInConfigSpring34
extends Recipe {
    private static final String CONFIGURATION_FQN = "org.springframework.context.annotation.Configuration";
    private static final String MOCKBEAN_FQN = "org.springframework.test.context.bean.override.mockito.Mockito*Bean";
    private static final String TODO_MSG = " TODO migrate into a test class, see https://docs.spring.io/spring-framework/reference/testing/annotations/integration-spring/annotation-mockitobean.html";
    private static final AnnotationMatcher mockBean = new AnnotationMatcher("@org.springframework.test.context.bean.override.mockito.Mockito*Bean", Boolean.valueOf(false));
    private static final AnnotationMatcher configuration = new AnnotationMatcher("@org.springframework.context.annotation.Configuration", Boolean.valueOf(false));

    public String getDisplayName() {
        return "Comment on `@MockitoSpyBean` and `@MockitoBean` in `@Configuration`";
    }

    public String getDescription() {
        return "As stated in [Spring Docs](https://docs.spring.io/spring-framework/reference/testing/annotations/integration-spring/annotation-mockitobean.html) `@MockitoSpyBean` and `@MockitoBean` will only work in tests, explicitly not in `@Configuration` annotated classes.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType(CONFIGURATION_FQN, Boolean.valueOf(false)), new UsesType(MOCKBEAN_FQN, Boolean.valueOf(false))}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
                J.Annotation ann = super.visitAnnotation(annotation, (Object)ctx);
                if (!mockBean.matches(ann) || !this.classDefinesConfiguration() || this.hasToDoComment(ann)) {
                    return ann;
                }
                return (J.Annotation)this.maybeAutoFormat((J)annotation, (J)((J.Annotation)ann.withComments(ListUtils.concat((List)ann.getComments(), (Object)new TextComment(false, CommentOnMockAndSpyBeansInConfigSpring34.TODO_MSG, "\n", Markers.EMPTY)))), ctx);
            }

            private boolean classDefinesConfiguration() {
                for (J.Annotation leadingAnnotation : ((J.ClassDeclaration)this.getCursor().firstEnclosingOrThrow(J.ClassDeclaration.class)).getLeadingAnnotations()) {
                    if (!configuration.matches(leadingAnnotation)) continue;
                    return true;
                }
                return false;
            }

            private boolean hasToDoComment(J.Annotation annotation) {
                for (Comment comment : annotation.getComments()) {
                    if (!(comment instanceof TextComment) || !CommentOnMockAndSpyBeansInConfigSpring34.TODO_MSG.equals(((TextComment)comment).getText())) continue;
                    return true;
                }
                return false;
            }
        });
    }

    @Generated
    public CommentOnMockAndSpyBeansInConfigSpring34() {
    }

    @Generated
    public String toString() {
        return "CommentOnMockAndSpyBeansInConfigSpring34()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommentOnMockAndSpyBeansInConfigSpring34)) {
            return false;
        }
        CommentOnMockAndSpyBeansInConfigSpring34 other = (CommentOnMockAndSpyBeansInConfigSpring34)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CommentOnMockAndSpyBeansInConfigSpring34;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

