/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.jsonrpc.handler;

import io.moderne.jsonrpc.JsonRpcMessage;
import io.moderne.jsonrpc.JsonRpcRequest;
import io.moderne.jsonrpc.JsonRpcResponse;
import io.moderne.jsonrpc.handler.MessageHandler;
import java.io.PrintStream;
import lombok.Generated;

public class TraceMessageHandler
implements MessageHandler {
    private final String name;
    private final MessageHandler delegate;
    private final PrintStream out;

    public TraceMessageHandler(String name, MessageHandler delegate) {
        this(name, delegate, System.out);
    }

    @Override
    public JsonRpcMessage receive() {
        JsonRpcMessage message = this.delegate.receive();
        if (message instanceof JsonRpcResponse) {
            this.out.printf("<-(%s)- %s%n", this.name, message);
        }
        return message;
    }

    @Override
    public void send(JsonRpcMessage message) {
        if (message instanceof JsonRpcRequest) {
            this.out.printf("-(%s)-> %s%n", this.name, message);
        }
        this.delegate.send(message);
    }

    @Generated
    public TraceMessageHandler(String name, MessageHandler delegate, PrintStream out) {
        this.name = name;
        this.delegate = delegate;
        this.out = out;
    }
}

