/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.server.McpAsyncServer;
import io.modelcontextprotocol.server.McpAsyncServerExchange;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.server.McpSyncServer;
import io.modelcontextprotocol.server.McpSyncServerExchange;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpServerTransportProvider;
import io.modelcontextprotocol.spec.ServerMcpTransport;
import io.modelcontextprotocol.util.Assert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public interface McpServer {
    public static SyncSpecification sync(McpServerTransportProvider transportProvider) {
        return new SyncSpecification(transportProvider);
    }

    @Deprecated
    public static SyncSpec sync(ServerMcpTransport transport) {
        return new SyncSpec(transport);
    }

    public static AsyncSpecification async(McpServerTransportProvider transportProvider) {
        return new AsyncSpecification(transportProvider);
    }

    @Deprecated
    public static AsyncSpec async(ServerMcpTransport transport) {
        return new AsyncSpec(transport);
    }

    public static class SyncSpecification {
        private static final McpSchema.Implementation DEFAULT_SERVER_INFO = new McpSchema.Implementation("mcp-server", "1.0.0");
        private final McpServerTransportProvider transportProvider;
        private ObjectMapper objectMapper;
        private McpSchema.Implementation serverInfo = DEFAULT_SERVER_INFO;
        private McpSchema.ServerCapabilities serverCapabilities;
        private final List<McpServerFeatures.SyncToolSpecification> tools = new ArrayList<McpServerFeatures.SyncToolSpecification>();
        private final Map<String, McpServerFeatures.SyncResourceSpecification> resources = new HashMap<String, McpServerFeatures.SyncResourceSpecification>();
        private final List<McpSchema.ResourceTemplate> resourceTemplates = new ArrayList<McpSchema.ResourceTemplate>();
        private final Map<String, McpServerFeatures.SyncPromptSpecification> prompts = new HashMap<String, McpServerFeatures.SyncPromptSpecification>();
        private final List<BiConsumer<McpSyncServerExchange, List<McpSchema.Root>>> rootsChangeHandlers = new ArrayList<BiConsumer<McpSyncServerExchange, List<McpSchema.Root>>>();

        private SyncSpecification(McpServerTransportProvider transportProvider) {
            Assert.notNull(transportProvider, "Transport provider must not be null");
            this.transportProvider = transportProvider;
        }

        public SyncSpecification serverInfo(McpSchema.Implementation serverInfo) {
            Assert.notNull(serverInfo, "Server info must not be null");
            this.serverInfo = serverInfo;
            return this;
        }

        public SyncSpecification serverInfo(String name, String version) {
            Assert.hasText(name, "Name must not be null or empty");
            Assert.hasText(version, "Version must not be null or empty");
            this.serverInfo = new McpSchema.Implementation(name, version);
            return this;
        }

        public SyncSpecification capabilities(McpSchema.ServerCapabilities serverCapabilities) {
            Assert.notNull(serverCapabilities, "Server capabilities must not be null");
            this.serverCapabilities = serverCapabilities;
            return this;
        }

        public SyncSpecification tool(McpSchema.Tool tool, BiFunction<McpSyncServerExchange, Map<String, Object>, McpSchema.CallToolResult> handler) {
            Assert.notNull(tool, "Tool must not be null");
            Assert.notNull(handler, "Handler must not be null");
            this.tools.add(new McpServerFeatures.SyncToolSpecification(tool, handler));
            return this;
        }

        public SyncSpecification tools(List<McpServerFeatures.SyncToolSpecification> toolSpecifications) {
            Assert.notNull(toolSpecifications, "Tool handlers list must not be null");
            this.tools.addAll(toolSpecifications);
            return this;
        }

        public SyncSpecification tools(McpServerFeatures.SyncToolSpecification ... toolSpecifications) {
            Assert.notNull(toolSpecifications, "Tool handlers list must not be null");
            for (McpServerFeatures.SyncToolSpecification tool : toolSpecifications) {
                this.tools.add(tool);
            }
            return this;
        }

        public SyncSpecification resources(Map<String, McpServerFeatures.SyncResourceSpecification> resourceSpecifications) {
            Assert.notNull(resourceSpecifications, "Resource handlers map must not be null");
            this.resources.putAll(resourceSpecifications);
            return this;
        }

        public SyncSpecification resources(List<McpServerFeatures.SyncResourceSpecification> resourceSpecifications) {
            Assert.notNull(resourceSpecifications, "Resource handlers list must not be null");
            for (McpServerFeatures.SyncResourceSpecification resource : resourceSpecifications) {
                this.resources.put(resource.resource().uri(), resource);
            }
            return this;
        }

        public SyncSpecification resources(McpServerFeatures.SyncResourceSpecification ... resourceSpecifications) {
            Assert.notNull(resourceSpecifications, "Resource handlers list must not be null");
            for (McpServerFeatures.SyncResourceSpecification resource : resourceSpecifications) {
                this.resources.put(resource.resource().uri(), resource);
            }
            return this;
        }

        public SyncSpecification resourceTemplates(List<McpSchema.ResourceTemplate> resourceTemplates) {
            Assert.notNull(resourceTemplates, "Resource templates must not be null");
            this.resourceTemplates.addAll(resourceTemplates);
            return this;
        }

        public SyncSpecification resourceTemplates(McpSchema.ResourceTemplate ... resourceTemplates) {
            Assert.notNull(resourceTemplates, "Resource templates must not be null");
            for (McpSchema.ResourceTemplate resourceTemplate : resourceTemplates) {
                this.resourceTemplates.add(resourceTemplate);
            }
            return this;
        }

        public SyncSpecification prompts(Map<String, McpServerFeatures.SyncPromptSpecification> prompts) {
            Assert.notNull(prompts, "Prompts map must not be null");
            this.prompts.putAll(prompts);
            return this;
        }

        public SyncSpecification prompts(List<McpServerFeatures.SyncPromptSpecification> prompts) {
            Assert.notNull(prompts, "Prompts list must not be null");
            for (McpServerFeatures.SyncPromptSpecification prompt : prompts) {
                this.prompts.put(prompt.prompt().name(), prompt);
            }
            return this;
        }

        public SyncSpecification prompts(McpServerFeatures.SyncPromptSpecification ... prompts) {
            Assert.notNull(prompts, "Prompts list must not be null");
            for (McpServerFeatures.SyncPromptSpecification prompt : prompts) {
                this.prompts.put(prompt.prompt().name(), prompt);
            }
            return this;
        }

        public SyncSpecification rootsChangeHandler(BiConsumer<McpSyncServerExchange, List<McpSchema.Root>> handler) {
            Assert.notNull(handler, "Consumer must not be null");
            this.rootsChangeHandlers.add(handler);
            return this;
        }

        public SyncSpecification rootsChangeHandlers(List<BiConsumer<McpSyncServerExchange, List<McpSchema.Root>>> handlers) {
            Assert.notNull(handlers, "Handlers list must not be null");
            this.rootsChangeHandlers.addAll(handlers);
            return this;
        }

        public SyncSpecification rootsChangeHandlers(BiConsumer<McpSyncServerExchange, List<McpSchema.Root>> ... handlers) {
            Assert.notNull(handlers, "Handlers list must not be null");
            return this.rootsChangeHandlers(List.of(handlers));
        }

        public SyncSpecification objectMapper(ObjectMapper objectMapper) {
            Assert.notNull(objectMapper, "ObjectMapper must not be null");
            this.objectMapper = objectMapper;
            return this;
        }

        public McpSyncServer build() {
            McpServerFeatures.Sync syncFeatures = new McpServerFeatures.Sync(this.serverInfo, this.serverCapabilities, this.tools, this.resources, this.resourceTemplates, this.prompts, this.rootsChangeHandlers);
            McpServerFeatures.Async asyncFeatures = McpServerFeatures.Async.fromSync(syncFeatures);
            ObjectMapper mapper = this.objectMapper != null ? this.objectMapper : new ObjectMapper();
            McpAsyncServer asyncServer = new McpAsyncServer(this.transportProvider, mapper, asyncFeatures);
            return new McpSyncServer(asyncServer);
        }
    }

    @Deprecated
    public static class SyncSpec {
        private static final McpSchema.Implementation DEFAULT_SERVER_INFO = new McpSchema.Implementation("mcp-server", "1.0.0");
        private final ServerMcpTransport transport;
        private final McpServerTransportProvider transportProvider;
        private ObjectMapper objectMapper;
        private McpSchema.Implementation serverInfo = DEFAULT_SERVER_INFO;
        private McpSchema.ServerCapabilities serverCapabilities;
        private final List<McpServerFeatures.SyncToolRegistration> tools = new ArrayList<McpServerFeatures.SyncToolRegistration>();
        private final Map<String, McpServerFeatures.SyncResourceRegistration> resources = new HashMap<String, McpServerFeatures.SyncResourceRegistration>();
        private final List<McpSchema.ResourceTemplate> resourceTemplates = new ArrayList<McpSchema.ResourceTemplate>();
        private final Map<String, McpServerFeatures.SyncPromptRegistration> prompts = new HashMap<String, McpServerFeatures.SyncPromptRegistration>();
        private final List<Consumer<List<McpSchema.Root>>> rootsChangeConsumers = new ArrayList<Consumer<List<McpSchema.Root>>>();

        private SyncSpec(McpServerTransportProvider transportProvider) {
            Assert.notNull(transportProvider, "Transport provider must not be null");
            this.transportProvider = transportProvider;
            this.transport = null;
        }

        private SyncSpec(ServerMcpTransport transport) {
            Assert.notNull(transport, "Transport must not be null");
            this.transport = transport;
            this.transportProvider = null;
        }

        public SyncSpec serverInfo(McpSchema.Implementation serverInfo) {
            Assert.notNull(serverInfo, "Server info must not be null");
            this.serverInfo = serverInfo;
            return this;
        }

        public SyncSpec serverInfo(String name, String version) {
            Assert.hasText(name, "Name must not be null or empty");
            Assert.hasText(version, "Version must not be null or empty");
            this.serverInfo = new McpSchema.Implementation(name, version);
            return this;
        }

        public SyncSpec capabilities(McpSchema.ServerCapabilities serverCapabilities) {
            this.serverCapabilities = serverCapabilities;
            return this;
        }

        public SyncSpec tool(McpSchema.Tool tool, Function<Map<String, Object>, McpSchema.CallToolResult> handler) {
            Assert.notNull(tool, "Tool must not be null");
            Assert.notNull(handler, "Handler must not be null");
            this.tools.add(new McpServerFeatures.SyncToolRegistration(tool, handler));
            return this;
        }

        public SyncSpec tools(List<McpServerFeatures.SyncToolRegistration> toolRegistrations) {
            Assert.notNull(toolRegistrations, "Tool handlers list must not be null");
            this.tools.addAll(toolRegistrations);
            return this;
        }

        public SyncSpec tools(McpServerFeatures.SyncToolRegistration ... toolRegistrations) {
            for (McpServerFeatures.SyncToolRegistration tool : toolRegistrations) {
                this.tools.add(tool);
            }
            return this;
        }

        public SyncSpec resources(Map<String, McpServerFeatures.SyncResourceRegistration> resourceRegsitrations) {
            Assert.notNull(resourceRegsitrations, "Resource handlers map must not be null");
            this.resources.putAll(resourceRegsitrations);
            return this;
        }

        public SyncSpec resources(List<McpServerFeatures.SyncResourceRegistration> resourceRegsitrations) {
            Assert.notNull(resourceRegsitrations, "Resource handlers list must not be null");
            for (McpServerFeatures.SyncResourceRegistration resource : resourceRegsitrations) {
                this.resources.put(resource.resource().uri(), resource);
            }
            return this;
        }

        public SyncSpec resources(McpServerFeatures.SyncResourceRegistration ... resourceRegistrations) {
            Assert.notNull(resourceRegistrations, "Resource handlers list must not be null");
            for (McpServerFeatures.SyncResourceRegistration resource : resourceRegistrations) {
                this.resources.put(resource.resource().uri(), resource);
            }
            return this;
        }

        public SyncSpec resourceTemplates(List<McpSchema.ResourceTemplate> resourceTemplates) {
            this.resourceTemplates.addAll(resourceTemplates);
            return this;
        }

        public SyncSpec resourceTemplates(McpSchema.ResourceTemplate ... resourceTemplates) {
            for (McpSchema.ResourceTemplate resourceTemplate : resourceTemplates) {
                this.resourceTemplates.add(resourceTemplate);
            }
            return this;
        }

        public SyncSpec prompts(Map<String, McpServerFeatures.SyncPromptRegistration> prompts) {
            this.prompts.putAll(prompts);
            return this;
        }

        public SyncSpec prompts(List<McpServerFeatures.SyncPromptRegistration> prompts) {
            for (McpServerFeatures.SyncPromptRegistration prompt : prompts) {
                this.prompts.put(prompt.prompt().name(), prompt);
            }
            return this;
        }

        public SyncSpec prompts(McpServerFeatures.SyncPromptRegistration ... prompts) {
            for (McpServerFeatures.SyncPromptRegistration prompt : prompts) {
                this.prompts.put(prompt.prompt().name(), prompt);
            }
            return this;
        }

        public SyncSpec rootsChangeConsumer(Consumer<List<McpSchema.Root>> consumer) {
            Assert.notNull(consumer, "Consumer must not be null");
            this.rootsChangeConsumers.add(consumer);
            return this;
        }

        public SyncSpec rootsChangeConsumers(List<Consumer<List<McpSchema.Root>>> consumers) {
            Assert.notNull(consumers, "Consumers list must not be null");
            this.rootsChangeConsumers.addAll(consumers);
            return this;
        }

        public SyncSpec rootsChangeConsumers(Consumer<List<McpSchema.Root>> ... consumers) {
            for (Consumer<List<McpSchema.Root>> consumer : consumers) {
                this.rootsChangeConsumers.add(consumer);
            }
            return this;
        }

        public McpSyncServer build() {
            List<McpServerFeatures.SyncToolSpecification> tools = this.tools.stream().map(McpServerFeatures.SyncToolRegistration::toSpecification).toList();
            Map<String, McpServerFeatures.SyncResourceSpecification> resources = this.resources.entrySet().stream().map(entry -> Map.entry((String)entry.getKey(), ((McpServerFeatures.SyncResourceRegistration)entry.getValue()).toSpecification())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            Map<String, McpServerFeatures.SyncPromptSpecification> prompts = this.prompts.entrySet().stream().map(entry -> Map.entry((String)entry.getKey(), ((McpServerFeatures.SyncPromptRegistration)entry.getValue()).toSpecification())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            List<BiConsumer<McpSyncServerExchange, List<McpSchema.Root>>> rootsChangeHandlers = this.rootsChangeConsumers.stream().map(consumer -> (exchange, roots) -> consumer.accept(roots)).toList();
            McpServerFeatures.Sync syncFeatures = new McpServerFeatures.Sync(this.serverInfo, this.serverCapabilities, tools, resources, this.resourceTemplates, prompts, rootsChangeHandlers);
            McpServerFeatures.Async asyncFeatures = McpServerFeatures.Async.fromSync(syncFeatures);
            McpAsyncServer asyncServer = new McpAsyncServer(this.transport, asyncFeatures);
            return new McpSyncServer(asyncServer);
        }
    }

    public static class AsyncSpecification {
        private static final McpSchema.Implementation DEFAULT_SERVER_INFO = new McpSchema.Implementation("mcp-server", "1.0.0");
        private final McpServerTransportProvider transportProvider;
        private ObjectMapper objectMapper;
        private McpSchema.Implementation serverInfo = DEFAULT_SERVER_INFO;
        private McpSchema.ServerCapabilities serverCapabilities;
        private final List<McpServerFeatures.AsyncToolSpecification> tools = new ArrayList<McpServerFeatures.AsyncToolSpecification>();
        private final Map<String, McpServerFeatures.AsyncResourceSpecification> resources = new HashMap<String, McpServerFeatures.AsyncResourceSpecification>();
        private final List<McpSchema.ResourceTemplate> resourceTemplates = new ArrayList<McpSchema.ResourceTemplate>();
        private final Map<String, McpServerFeatures.AsyncPromptSpecification> prompts = new HashMap<String, McpServerFeatures.AsyncPromptSpecification>();
        private final List<BiFunction<McpAsyncServerExchange, List<McpSchema.Root>, Mono<Void>>> rootsChangeHandlers = new ArrayList<BiFunction<McpAsyncServerExchange, List<McpSchema.Root>, Mono<Void>>>();

        private AsyncSpecification(McpServerTransportProvider transportProvider) {
            Assert.notNull(transportProvider, "Transport provider must not be null");
            this.transportProvider = transportProvider;
        }

        public AsyncSpecification serverInfo(McpSchema.Implementation serverInfo) {
            Assert.notNull(serverInfo, "Server info must not be null");
            this.serverInfo = serverInfo;
            return this;
        }

        public AsyncSpecification serverInfo(String name, String version) {
            Assert.hasText(name, "Name must not be null or empty");
            Assert.hasText(version, "Version must not be null or empty");
            this.serverInfo = new McpSchema.Implementation(name, version);
            return this;
        }

        public AsyncSpecification capabilities(McpSchema.ServerCapabilities serverCapabilities) {
            Assert.notNull(serverCapabilities, "Server capabilities must not be null");
            this.serverCapabilities = serverCapabilities;
            return this;
        }

        public AsyncSpecification tool(McpSchema.Tool tool, BiFunction<McpAsyncServerExchange, Map<String, Object>, Mono<McpSchema.CallToolResult>> handler) {
            Assert.notNull(tool, "Tool must not be null");
            Assert.notNull(handler, "Handler must not be null");
            this.tools.add(new McpServerFeatures.AsyncToolSpecification(tool, handler));
            return this;
        }

        public AsyncSpecification tools(List<McpServerFeatures.AsyncToolSpecification> toolSpecifications) {
            Assert.notNull(toolSpecifications, "Tool handlers list must not be null");
            this.tools.addAll(toolSpecifications);
            return this;
        }

        public AsyncSpecification tools(McpServerFeatures.AsyncToolSpecification ... toolSpecifications) {
            Assert.notNull(toolSpecifications, "Tool handlers list must not be null");
            for (McpServerFeatures.AsyncToolSpecification tool : toolSpecifications) {
                this.tools.add(tool);
            }
            return this;
        }

        public AsyncSpecification resources(Map<String, McpServerFeatures.AsyncResourceSpecification> resourceSpecifications) {
            Assert.notNull(resourceSpecifications, "Resource handlers map must not be null");
            this.resources.putAll(resourceSpecifications);
            return this;
        }

        public AsyncSpecification resources(List<McpServerFeatures.AsyncResourceSpecification> resourceSpecifications) {
            Assert.notNull(resourceSpecifications, "Resource handlers list must not be null");
            for (McpServerFeatures.AsyncResourceSpecification resource : resourceSpecifications) {
                this.resources.put(resource.resource().uri(), resource);
            }
            return this;
        }

        public AsyncSpecification resources(McpServerFeatures.AsyncResourceSpecification ... resourceSpecifications) {
            Assert.notNull(resourceSpecifications, "Resource handlers list must not be null");
            for (McpServerFeatures.AsyncResourceSpecification resource : resourceSpecifications) {
                this.resources.put(resource.resource().uri(), resource);
            }
            return this;
        }

        public AsyncSpecification resourceTemplates(List<McpSchema.ResourceTemplate> resourceTemplates) {
            Assert.notNull(resourceTemplates, "Resource templates must not be null");
            this.resourceTemplates.addAll(resourceTemplates);
            return this;
        }

        public AsyncSpecification resourceTemplates(McpSchema.ResourceTemplate ... resourceTemplates) {
            Assert.notNull(resourceTemplates, "Resource templates must not be null");
            for (McpSchema.ResourceTemplate resourceTemplate : resourceTemplates) {
                this.resourceTemplates.add(resourceTemplate);
            }
            return this;
        }

        public AsyncSpecification prompts(Map<String, McpServerFeatures.AsyncPromptSpecification> prompts) {
            Assert.notNull(prompts, "Prompts map must not be null");
            this.prompts.putAll(prompts);
            return this;
        }

        public AsyncSpecification prompts(List<McpServerFeatures.AsyncPromptSpecification> prompts) {
            Assert.notNull(prompts, "Prompts list must not be null");
            for (McpServerFeatures.AsyncPromptSpecification prompt : prompts) {
                this.prompts.put(prompt.prompt().name(), prompt);
            }
            return this;
        }

        public AsyncSpecification prompts(McpServerFeatures.AsyncPromptSpecification ... prompts) {
            Assert.notNull(prompts, "Prompts list must not be null");
            for (McpServerFeatures.AsyncPromptSpecification prompt : prompts) {
                this.prompts.put(prompt.prompt().name(), prompt);
            }
            return this;
        }

        public AsyncSpecification rootsChangeHandler(BiFunction<McpAsyncServerExchange, List<McpSchema.Root>, Mono<Void>> handler) {
            Assert.notNull(handler, "Consumer must not be null");
            this.rootsChangeHandlers.add(handler);
            return this;
        }

        public AsyncSpecification rootsChangeHandlers(List<BiFunction<McpAsyncServerExchange, List<McpSchema.Root>, Mono<Void>>> handlers) {
            Assert.notNull(handlers, "Handlers list must not be null");
            this.rootsChangeHandlers.addAll(handlers);
            return this;
        }

        public AsyncSpecification rootsChangeHandlers(BiFunction<McpAsyncServerExchange, List<McpSchema.Root>, Mono<Void>> ... handlers) {
            Assert.notNull(handlers, "Handlers list must not be null");
            return this.rootsChangeHandlers(Arrays.asList(handlers));
        }

        public AsyncSpecification objectMapper(ObjectMapper objectMapper) {
            Assert.notNull(objectMapper, "ObjectMapper must not be null");
            this.objectMapper = objectMapper;
            return this;
        }

        public McpAsyncServer build() {
            McpServerFeatures.Async features = new McpServerFeatures.Async(this.serverInfo, this.serverCapabilities, this.tools, this.resources, this.resourceTemplates, this.prompts, this.rootsChangeHandlers);
            ObjectMapper mapper = this.objectMapper != null ? this.objectMapper : new ObjectMapper();
            return new McpAsyncServer(this.transportProvider, mapper, features);
        }
    }

    @Deprecated
    public static class AsyncSpec {
        private static final McpSchema.Implementation DEFAULT_SERVER_INFO = new McpSchema.Implementation("mcp-server", "1.0.0");
        private final ServerMcpTransport transport;
        private ObjectMapper objectMapper;
        private McpSchema.Implementation serverInfo = DEFAULT_SERVER_INFO;
        private McpSchema.ServerCapabilities serverCapabilities;
        private final List<McpServerFeatures.AsyncToolRegistration> tools = new ArrayList<McpServerFeatures.AsyncToolRegistration>();
        private final Map<String, McpServerFeatures.AsyncResourceRegistration> resources = new HashMap<String, McpServerFeatures.AsyncResourceRegistration>();
        private final List<McpSchema.ResourceTemplate> resourceTemplates = new ArrayList<McpSchema.ResourceTemplate>();
        private final Map<String, McpServerFeatures.AsyncPromptRegistration> prompts = new HashMap<String, McpServerFeatures.AsyncPromptRegistration>();
        private final List<Function<List<McpSchema.Root>, Mono<Void>>> rootsChangeConsumers = new ArrayList<Function<List<McpSchema.Root>, Mono<Void>>>();

        private AsyncSpec(ServerMcpTransport transport) {
            Assert.notNull(transport, "Transport must not be null");
            this.transport = transport;
        }

        public AsyncSpec serverInfo(McpSchema.Implementation serverInfo) {
            Assert.notNull(serverInfo, "Server info must not be null");
            this.serverInfo = serverInfo;
            return this;
        }

        public AsyncSpec serverInfo(String name, String version) {
            Assert.hasText(name, "Name must not be null or empty");
            Assert.hasText(version, "Version must not be null or empty");
            this.serverInfo = new McpSchema.Implementation(name, version);
            return this;
        }

        public AsyncSpec capabilities(McpSchema.ServerCapabilities serverCapabilities) {
            this.serverCapabilities = serverCapabilities;
            return this;
        }

        public AsyncSpec tool(McpSchema.Tool tool, Function<Map<String, Object>, Mono<McpSchema.CallToolResult>> handler) {
            Assert.notNull(tool, "Tool must not be null");
            Assert.notNull(handler, "Handler must not be null");
            this.tools.add(new McpServerFeatures.AsyncToolRegistration(tool, handler));
            return this;
        }

        public AsyncSpec tools(List<McpServerFeatures.AsyncToolRegistration> toolRegistrations) {
            Assert.notNull(toolRegistrations, "Tool handlers list must not be null");
            this.tools.addAll(toolRegistrations);
            return this;
        }

        public AsyncSpec tools(McpServerFeatures.AsyncToolRegistration ... toolRegistrations) {
            for (McpServerFeatures.AsyncToolRegistration tool : toolRegistrations) {
                this.tools.add(tool);
            }
            return this;
        }

        public AsyncSpec resources(Map<String, McpServerFeatures.AsyncResourceRegistration> resourceRegsitrations) {
            Assert.notNull(resourceRegsitrations, "Resource handlers map must not be null");
            this.resources.putAll(resourceRegsitrations);
            return this;
        }

        public AsyncSpec resources(List<McpServerFeatures.AsyncResourceRegistration> resourceRegsitrations) {
            Assert.notNull(resourceRegsitrations, "Resource handlers list must not be null");
            for (McpServerFeatures.AsyncResourceRegistration resource : resourceRegsitrations) {
                this.resources.put(resource.resource().uri(), resource);
            }
            return this;
        }

        public AsyncSpec resources(McpServerFeatures.AsyncResourceRegistration ... resourceRegistrations) {
            Assert.notNull(resourceRegistrations, "Resource handlers list must not be null");
            for (McpServerFeatures.AsyncResourceRegistration resource : resourceRegistrations) {
                this.resources.put(resource.resource().uri(), resource);
            }
            return this;
        }

        public AsyncSpec resourceTemplates(List<McpSchema.ResourceTemplate> resourceTemplates) {
            this.resourceTemplates.addAll(resourceTemplates);
            return this;
        }

        public AsyncSpec resourceTemplates(McpSchema.ResourceTemplate ... resourceTemplates) {
            for (McpSchema.ResourceTemplate resourceTemplate : resourceTemplates) {
                this.resourceTemplates.add(resourceTemplate);
            }
            return this;
        }

        public AsyncSpec prompts(Map<String, McpServerFeatures.AsyncPromptRegistration> prompts) {
            this.prompts.putAll(prompts);
            return this;
        }

        public AsyncSpec prompts(List<McpServerFeatures.AsyncPromptRegistration> prompts) {
            for (McpServerFeatures.AsyncPromptRegistration prompt : prompts) {
                this.prompts.put(prompt.prompt().name(), prompt);
            }
            return this;
        }

        public AsyncSpec prompts(McpServerFeatures.AsyncPromptRegistration ... prompts) {
            for (McpServerFeatures.AsyncPromptRegistration prompt : prompts) {
                this.prompts.put(prompt.prompt().name(), prompt);
            }
            return this;
        }

        public AsyncSpec rootsChangeConsumer(Function<List<McpSchema.Root>, Mono<Void>> consumer) {
            Assert.notNull(consumer, "Consumer must not be null");
            this.rootsChangeConsumers.add(consumer);
            return this;
        }

        public AsyncSpec rootsChangeConsumers(List<Function<List<McpSchema.Root>, Mono<Void>>> consumers) {
            Assert.notNull(consumers, "Consumers list must not be null");
            this.rootsChangeConsumers.addAll(consumers);
            return this;
        }

        public AsyncSpec rootsChangeConsumers(Function<List<McpSchema.Root>, Mono<Void>> ... consumers) {
            for (Function<List<McpSchema.Root>, Mono<Void>> consumer : consumers) {
                this.rootsChangeConsumers.add(consumer);
            }
            return this;
        }

        public McpAsyncServer build() {
            List<McpServerFeatures.AsyncToolSpecification> tools = this.tools.stream().map(McpServerFeatures.AsyncToolRegistration::toSpecification).toList();
            Map<String, McpServerFeatures.AsyncResourceSpecification> resources = this.resources.entrySet().stream().map(entry -> Map.entry((String)entry.getKey(), ((McpServerFeatures.AsyncResourceRegistration)entry.getValue()).toSpecification())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            Map<String, McpServerFeatures.AsyncPromptSpecification> prompts = this.prompts.entrySet().stream().map(entry -> Map.entry((String)entry.getKey(), ((McpServerFeatures.AsyncPromptRegistration)entry.getValue()).toSpecification())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            List<BiFunction<McpAsyncServerExchange, List<McpSchema.Root>, Mono<Void>>> rootsChangeHandlers = this.rootsChangeConsumers.stream().map(consumer -> (exchange, roots) -> (Mono)consumer.apply(roots)).toList();
            McpServerFeatures.Async features = new McpServerFeatures.Async(this.serverInfo, this.serverCapabilities, tools, resources, this.resourceTemplates, prompts, rootsChangeHandlers);
            return new McpAsyncServer(this.transport, features);
        }
    }
}

