/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.server;

import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import io.modelcontextprotocol.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class McpServerFeatures {

    public record SyncPromptRegistration(McpSchema.Prompt prompt, Function<McpSchema.GetPromptRequest, McpSchema.GetPromptResult> promptHandler) {
    }

    public record SyncResourceRegistration(McpSchema.Resource resource, Function<McpSchema.ReadResourceRequest, McpSchema.ReadResourceResult> readHandler) {
    }

    public record SyncToolRegistration(McpSchema.Tool tool, Function<Map<String, Object>, McpSchema.CallToolResult> call) {
    }

    public record AsyncPromptRegistration(McpSchema.Prompt prompt, Function<McpSchema.GetPromptRequest, Mono<McpSchema.GetPromptResult>> promptHandler) {
        static AsyncPromptRegistration fromSync(SyncPromptRegistration prompt) {
            if (prompt == null) {
                return null;
            }
            return new AsyncPromptRegistration(prompt.prompt(), req -> Mono.fromCallable(() -> prompt.promptHandler().apply((McpSchema.GetPromptRequest)req)).subscribeOn(Schedulers.boundedElastic()));
        }
    }

    public record AsyncResourceRegistration(McpSchema.Resource resource, Function<McpSchema.ReadResourceRequest, Mono<McpSchema.ReadResourceResult>> readHandler) {
        static AsyncResourceRegistration fromSync(SyncResourceRegistration resource) {
            if (resource == null) {
                return null;
            }
            return new AsyncResourceRegistration(resource.resource(), req -> Mono.fromCallable(() -> resource.readHandler().apply((McpSchema.ReadResourceRequest)req)).subscribeOn(Schedulers.boundedElastic()));
        }
    }

    public record AsyncToolRegistration(McpSchema.Tool tool, Function<Map<String, Object>, Mono<McpSchema.CallToolResult>> call) {
        static AsyncToolRegistration fromSync(SyncToolRegistration tool) {
            if (tool == null) {
                return null;
            }
            return new AsyncToolRegistration(tool.tool(), map -> Mono.fromCallable(() -> tool.call().apply((Map<String, Object>)map)).subscribeOn(Schedulers.boundedElastic()));
        }
    }

    record Sync(McpSchema.Implementation serverInfo, McpSchema.ServerCapabilities serverCapabilities, List<SyncToolRegistration> tools, Map<String, SyncResourceRegistration> resources, List<McpSchema.ResourceTemplate> resourceTemplates, Map<String, SyncPromptRegistration> prompts, List<Consumer<List<McpSchema.Root>>> rootsChangeConsumers) {
        Sync(McpSchema.Implementation serverInfo, McpSchema.ServerCapabilities serverCapabilities, List<SyncToolRegistration> tools, Map<String, SyncResourceRegistration> resources, List<McpSchema.ResourceTemplate> resourceTemplates, Map<String, SyncPromptRegistration> prompts, List<Consumer<List<McpSchema.Root>>> rootsChangeConsumers) {
            Assert.notNull(serverInfo, "Server info must not be null");
            this.serverInfo = serverInfo;
            this.serverCapabilities = serverCapabilities != null ? serverCapabilities : new McpSchema.ServerCapabilities(null, new McpSchema.ServerCapabilities.LoggingCapabilities(), !Utils.isEmpty(prompts) ? new McpSchema.ServerCapabilities.PromptCapabilities(false) : null, !Utils.isEmpty(resources) ? new McpSchema.ServerCapabilities.ResourceCapabilities(false, false) : null, !Utils.isEmpty(tools) ? new McpSchema.ServerCapabilities.ToolCapabilities(false) : null);
            this.tools = tools != null ? tools : new ArrayList();
            this.resources = resources != null ? resources : new HashMap();
            this.resourceTemplates = resourceTemplates != null ? resourceTemplates : new ArrayList();
            this.prompts = prompts != null ? prompts : new HashMap();
            this.rootsChangeConsumers = rootsChangeConsumers != null ? rootsChangeConsumers : new ArrayList();
        }
    }

    record Async(McpSchema.Implementation serverInfo, McpSchema.ServerCapabilities serverCapabilities, List<AsyncToolRegistration> tools, Map<String, AsyncResourceRegistration> resources, List<McpSchema.ResourceTemplate> resourceTemplates, Map<String, AsyncPromptRegistration> prompts, List<Function<List<McpSchema.Root>, Mono<Void>>> rootsChangeConsumers) {
        Async(McpSchema.Implementation serverInfo, McpSchema.ServerCapabilities serverCapabilities, List<AsyncToolRegistration> tools, Map<String, AsyncResourceRegistration> resources, List<McpSchema.ResourceTemplate> resourceTemplates, Map<String, AsyncPromptRegistration> prompts, List<Function<List<McpSchema.Root>, Mono<Void>>> rootsChangeConsumers) {
            Assert.notNull(serverInfo, "Server info must not be null");
            this.serverInfo = serverInfo;
            this.serverCapabilities = serverCapabilities != null ? serverCapabilities : new McpSchema.ServerCapabilities(null, new McpSchema.ServerCapabilities.LoggingCapabilities(), !Utils.isEmpty(prompts) ? new McpSchema.ServerCapabilities.PromptCapabilities(false) : null, !Utils.isEmpty(resources) ? new McpSchema.ServerCapabilities.ResourceCapabilities(false, false) : null, !Utils.isEmpty(tools) ? new McpSchema.ServerCapabilities.ToolCapabilities(false) : null);
            this.tools = tools != null ? tools : List.of();
            this.resources = resources != null ? resources : Map.of();
            this.resourceTemplates = resourceTemplates != null ? resourceTemplates : List.of();
            this.prompts = prompts != null ? prompts : Map.of();
            this.rootsChangeConsumers = rootsChangeConsumers != null ? rootsChangeConsumers : List.of();
        }

        static Async fromSync(Sync syncSpec) {
            ArrayList<AsyncToolRegistration> tools = new ArrayList<AsyncToolRegistration>();
            for (SyncToolRegistration tool : syncSpec.tools()) {
                tools.add(AsyncToolRegistration.fromSync(tool));
            }
            HashMap<String, AsyncResourceRegistration> resources = new HashMap<String, AsyncResourceRegistration>();
            syncSpec.resources().forEach((key, resource) -> resources.put((String)key, AsyncResourceRegistration.fromSync(resource)));
            HashMap<String, AsyncPromptRegistration> prompts = new HashMap<String, AsyncPromptRegistration>();
            syncSpec.prompts().forEach((key, prompt) -> prompts.put((String)key, AsyncPromptRegistration.fromSync(prompt)));
            ArrayList<Function<List<McpSchema.Root>, Mono<Void>>> rootChangeConsumers = new ArrayList<Function<List<McpSchema.Root>, Mono<Void>>>();
            for (Consumer<List<McpSchema.Root>> rootChangeConsumer : syncSpec.rootsChangeConsumers()) {
                rootChangeConsumers.add(list -> Mono.fromRunnable(() -> rootChangeConsumer.accept((List<McpSchema.Root>)list)).subscribeOn(Schedulers.boundedElastic()));
            }
            return new Async(syncSpec.serverInfo(), syncSpec.serverCapabilities(), tools, resources, syncSpec.resourceTemplates(), prompts, rootChangeConsumers);
        }
    }
}

