/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.server;

import io.modelcontextprotocol.server.McpStatelessNotificationHandler;
import io.modelcontextprotocol.server.McpStatelessRequestHandler;
import io.modelcontextprotocol.server.McpStatelessServerHandler;
import io.modelcontextprotocol.server.McpTransportContext;
import io.modelcontextprotocol.spec.McpError;
import io.modelcontextprotocol.spec.McpSchema;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

class DefaultMcpStatelessServerHandler
implements McpStatelessServerHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultMcpStatelessServerHandler.class);
    Map<String, McpStatelessRequestHandler<?>> requestHandlers;
    Map<String, McpStatelessNotificationHandler> notificationHandlers;

    public DefaultMcpStatelessServerHandler(Map<String, McpStatelessRequestHandler<?>> requestHandlers, Map<String, McpStatelessNotificationHandler> notificationHandlers) {
        this.requestHandlers = requestHandlers;
        this.notificationHandlers = notificationHandlers;
    }

    @Override
    public Mono<McpSchema.JSONRPCResponse> handleRequest(McpTransportContext transportContext, McpSchema.JSONRPCRequest request) {
        McpStatelessRequestHandler<?> requestHandler = this.requestHandlers.get(request.method());
        if (requestHandler == null) {
            return Mono.error((Throwable)new McpError((Object)("Missing handler for request type: " + request.method())));
        }
        return requestHandler.handle(transportContext, request.params()).map(result -> new McpSchema.JSONRPCResponse("2.0", request.id(), result, null)).onErrorResume(t -> Mono.just((Object)new McpSchema.JSONRPCResponse("2.0", request.id(), null, new McpSchema.JSONRPCResponse.JSONRPCError(-32603, t.getMessage(), null))));
    }

    @Override
    public Mono<Void> handleNotification(McpTransportContext transportContext, McpSchema.JSONRPCNotification notification) {
        McpStatelessNotificationHandler notificationHandler = this.notificationHandlers.get(notification.method());
        if (notificationHandler == null) {
            logger.warn("Missing handler for notification type: {}", (Object)notification.method());
            return Mono.empty();
        }
        return notificationHandler.handle(transportContext, notification.params());
    }
}

